/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.sampler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.util.JMeterUtils;

@GUIMenuSortOrder(value=2)
@TestElementMetadata(labelResource="displayName")
public class DebugSampler
extends AbstractSampler
implements TestBean {
    private static final long serialVersionUID = 232L;
    private static final Set<String> APPLIABLE_CONFIG_CLASSES = new HashSet<String>(Arrays.asList("org.apache.jmeter.config.gui.SimpleConfigGui"));
    private boolean displayJMeterVariables;
    private boolean displayJMeterProperties;
    private boolean displaySystemProperties;

    @Override
    public SampleResult sample(Entry e) {
        SampleResult res = new SampleResult();
        res.setSampleLabel(this.getName());
        res.sampleStart();
        StringBuilder sb = new StringBuilder(100);
        StringBuilder rd = new StringBuilder(20);
        if (this.isDisplayJMeterVariables()) {
            rd.append("JMeterVariables\n");
            sb.append("JMeterVariables:\n");
            this.formatSet(sb, JMeterContextService.getContext().getVariables().entrySet());
            sb.append("\n");
        }
        if (this.isDisplayJMeterProperties()) {
            rd.append("JMeterProperties\n");
            sb.append("JMeterProperties:\n");
            this.formatSet(sb, JMeterUtils.getJMeterProperties().entrySet());
            sb.append("\n");
        }
        if (this.isDisplaySystemProperties()) {
            rd.append("SystemProperties\n");
            sb.append("SystemProperties:\n");
            this.formatSet(sb, System.getProperties().entrySet());
            sb.append("\n");
        }
        res.setResponseData(sb.toString(), null);
        res.setDataType("text");
        res.setSamplerData(rd.toString());
        res.setResponseOK();
        res.sampleEnd();
        return res;
    }

    private void formatSet(StringBuilder sb, Set s) {
        ArrayList al = new ArrayList(s);
        al.sort((o1, o2) -> {
            String m1 = (String)o1.getKey();
            String m2 = (String)o2.getKey();
            return m1.compareTo(m2);
        });
        al.forEach(me -> sb.append(me.getKey()).append("=").append(me.getValue()).append("\n"));
    }

    public boolean isDisplayJMeterVariables() {
        return this.displayJMeterVariables;
    }

    public void setDisplayJMeterVariables(boolean displayJMeterVariables) {
        this.displayJMeterVariables = displayJMeterVariables;
    }

    public boolean isDisplayJMeterProperties() {
        return this.displayJMeterProperties;
    }

    public void setDisplayJMeterProperties(boolean displayJMeterProperties) {
        this.displayJMeterProperties = displayJMeterProperties;
    }

    public boolean isDisplaySystemProperties() {
        return this.displaySystemProperties;
    }

    public void setDisplaySystemProperties(boolean displaySystemProperties) {
        this.displaySystemProperties = displaySystemProperties;
    }

    @Override
    public boolean applies(ConfigTestElement configElement) {
        String guiClass = configElement.getProperty("TestElement.gui_class").getStringValue();
        return APPLIABLE_CONFIG_CLASSES.contains(guiClass);
    }
}

