/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.sampler;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.Interruptible;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.timers.TimerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAction
extends AbstractSampler
implements Interruptible {
    private static final Logger log = LoggerFactory.getLogger(TestAction.class);
    private static final String MSG_STOP_CURRENT_THREAD = "Stopping current thread from element {}";
    private static final TimerService TIMER_SERVICE = TimerService.getInstance();
    private static final long serialVersionUID = 242L;
    private static final Set<String> APPLIABLE_CONFIG_CLASSES = new HashSet<String>(Arrays.asList("org.apache.jmeter.config.gui.SimpleConfigGui"));
    public static final int STOP = 0;
    public static final int PAUSE = 1;
    public static final int STOP_NOW = 2;
    public static final int RESTART_NEXT_LOOP = 3;
    public static final int START_NEXT_ITERATION_CURRENT_LOOP = 4;
    public static final int BREAK_CURRENT_LOOP = 5;
    public static final int THREAD = 0;
    public static final int TEST = 2;
    private static final String TARGET = "ActionProcessor.target";
    private static final String ACTION = "ActionProcessor.action";
    private static final String DURATION = "ActionProcessor.duration";
    private volatile transient Thread pauseThread;

    @Override
    public SampleResult sample(Entry e) {
        JMeterContext context = JMeterContextService.getContext();
        int target = this.getTarget();
        int action = this.getAction();
        if (action == 1) {
            this.pause(this.getDurationAsString());
        } else if (action == 0 || action == 2) {
            if (target == 0) {
                if (log.isInfoEnabled()) {
                    log.info(MSG_STOP_CURRENT_THREAD, (Object)this.getName());
                }
                context.getThread().stop();
            } else if (target == 2) {
                if (action == 2) {
                    if (log.isInfoEnabled()) {
                        log.info(MSG_STOP_CURRENT_THREAD, (Object)this.getName());
                    }
                    context.getThread().stop();
                    if (log.isInfoEnabled()) {
                        log.info("Stopping all threads now from element {}", (Object)this.getName());
                    }
                    context.getEngine().stopTest();
                } else {
                    if (log.isInfoEnabled()) {
                        log.info(MSG_STOP_CURRENT_THREAD, (Object)this.getName());
                    }
                    context.getThread().stop();
                    if (log.isInfoEnabled()) {
                        log.info("Stopping all threads from element {}", (Object)this.getName());
                    }
                    context.getEngine().askThreadsToStop();
                }
            }
        } else if (action == 3) {
            log.info("Restarting next thread loop from element {}", (Object)this.getName());
            context.setTestLogicalAction(JMeterContext.TestLogicalAction.START_NEXT_ITERATION_OF_THREAD);
        } else if (action == 4) {
            log.info("Switching to next loop iteration from element {}", (Object)this.getName());
            context.setTestLogicalAction(JMeterContext.TestLogicalAction.START_NEXT_ITERATION_OF_CURRENT_LOOP);
        } else if (action == 5) {
            log.info("Breaking current loop from element {}", (Object)this.getName());
            context.setTestLogicalAction(JMeterContext.TestLogicalAction.BREAK_CURRENT_LOOP);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pause(String timeInMillis) {
        long millis;
        try {
            if (!StringUtils.isEmpty(timeInMillis)) {
                millis = Long.parseLong(timeInMillis);
            } else {
                log.warn("Duration value is empty, defaulting to 0");
                millis = 0L;
            }
        }
        catch (NumberFormatException e) {
            log.warn("Could not parse number: '{}'", (Object)timeInMillis);
            millis = 0L;
        }
        try {
            this.pauseThread = Thread.currentThread();
            if (millis > 0L) {
                long adjustDelay = TIMER_SERVICE.adjustDelay(millis);
                if (log.isDebugEnabled()) {
                    log.debug("Sleeping in Flow Control Action for {} ms (asked for {} ms)", (Object)adjustDelay, (Object)millis);
                }
                TimeUnit.MILLISECONDS.sleep(adjustDelay);
            } else if (millis < 0L) {
                throw new IllegalArgumentException("Configured sleep is negative:" + millis);
            }
        }
        catch (InterruptedException e) {
            log.debug("Flow Control Action got interrupted");
            Thread.currentThread().interrupt();
        }
        finally {
            this.pauseThread = null;
        }
    }

    public void setTarget(int target) {
        this.setProperty(new IntegerProperty(TARGET, target));
    }

    public int getTarget() {
        return this.getPropertyAsInt(TARGET);
    }

    public void setAction(int action) {
        this.setProperty(new IntegerProperty(ACTION, action));
    }

    public int getAction() {
        return this.getPropertyAsInt(ACTION);
    }

    public void setDuration(String duration) {
        this.setProperty(new StringProperty(DURATION, duration));
    }

    public String getDurationAsString() {
        return this.getPropertyAsString(DURATION);
    }

    @Override
    public boolean applies(ConfigTestElement configElement) {
        String guiClass = configElement.getProperty("TestElement.gui_class").getStringValue();
        return APPLIABLE_CONFIG_CLASSES.contains(guiClass);
    }

    @Override
    public boolean interrupt() {
        Thread thrd = this.pauseThread;
        if (thrd != null) {
            thrd.interrupt();
            return true;
        }
        return false;
    }
}

