/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.samplers;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.ConnectException;
import java.rmi.RemoteException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.jmeter.samplers.AbstractSampleSender;
import org.apache.jmeter.samplers.RemoteSampleListener;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jorphan.util.JMeterError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskStoreSampleSender
extends AbstractSampleSender
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(DiskStoreSampleSender.class);
    private static final long serialVersionUID = 253L;
    private final RemoteSampleListener listener;
    private volatile transient ObjectOutputStream oos;
    private volatile transient File temporaryFile;
    private volatile transient ExecutorService singleExecutor;

    @Deprecated
    public DiskStoreSampleSender() {
        log.warn("Constructor only intended for use in testing");
        this.listener = null;
    }

    DiskStoreSampleSender(RemoteSampleListener listener) {
        this.listener = listener;
        log.info("Using DiskStoreSampleSender for this test run");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testEnded(String host) {
        log.info("Test Ended on {}", (Object)host);
        this.singleExecutor.submit(() -> {
            try {
                this.oos.close();
            }
            catch (IOException e) {
                log.error("Failed to close data file.", e);
            }
        });
        this.singleExecutor.shutdown();
        try {
            if (!this.singleExecutor.awaitTermination(3L, TimeUnit.SECONDS)) {
                log.error("Executor did not terminate in a timely fashion");
            }
        }
        catch (InterruptedException e) {
            log.error("Executor did not terminate in a timely fashion", e);
            Thread.currentThread().interrupt();
        }
        try (FileInputStream fis = new FileInputStream(this.temporaryFile);
             ObjectInputStream ois = new ObjectInputStream(fis);){
            Object obj;
            while ((obj = ois.readObject()) != null) {
                if (obj instanceof SampleEvent) {
                    try {
                        this.listener.sampleOccurred((SampleEvent)obj);
                    }
                    catch (RemoteException err) {
                        if (err.getCause() instanceof ConnectException) {
                            throw new JMeterError("Could not return sample", err);
                        }
                        log.error("returning sample", err);
                    }
                    continue;
                }
                log.error("Unexpected object type found in data file. {}", (Object)obj.getClass());
            }
        }
        catch (EOFException e) {
        }
        catch (IOException | ClassNotFoundException err) {
            log.error("returning sample", err);
        }
        finally {
            try {
                this.listener.testEnded(host);
            }
            catch (RemoteException e) {
                log.error("returning sample", e);
            }
            if (!this.temporaryFile.delete() && log.isWarnEnabled()) {
                log.warn("Could not delete file: {}", (Object)this.temporaryFile.getAbsolutePath());
            }
        }
    }

    @Override
    public void sampleOccurred(SampleEvent e) {
        this.singleExecutor.submit(() -> {
            try {
                this.oos.writeObject(e);
            }
            catch (IOException err) {
                log.error("sampleOccurred", err);
            }
        });
    }

    private Object readResolve() throws ObjectStreamException {
        log.info("Using DiskStoreSampleSender for this test run");
        this.singleExecutor = Executors.newSingleThreadExecutor();
        try {
            this.temporaryFile = File.createTempFile("SerialisedSampleSender", ".ser");
            this.temporaryFile.deleteOnExit();
            this.singleExecutor.submit(() -> {
                try {
                    FileOutputStream anOutputStream = new FileOutputStream(this.temporaryFile);
                    this.oos = new ObjectOutputStream(anOutputStream);
                }
                catch (IOException e) {
                    log.error("Failed to create output Stream", e);
                }
            });
        }
        catch (IOException e) {
            log.error("Failed to create output file", e);
        }
        return this;
    }
}

