/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.save.converters;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.AbstractCollectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.SampleSaveConfiguration;
import org.apache.jmeter.save.converters.ConversionHelp;
import org.apache.jorphan.util.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleResultConverter
extends AbstractCollectionConverter {
    private static final Logger log = LoggerFactory.getLogger(SampleResultConverter.class);
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String ATT_CLASS = "class";
    protected static final String TAG_COOKIES = "cookies";
    protected static final String TAG_METHOD = "method";
    protected static final String TAG_QUERY_STRING = "queryString";
    protected static final String TAG_REDIRECT_LOCATION = "redirectLocation";
    protected static final String TAG_REQUEST_HEADER = "requestHeader";
    protected static final String TAG_RESPONSE_DATA = "responseData";
    protected static final String TAG_RESPONSE_HEADER = "responseHeader";
    protected static final String TAG_SAMPLER_DATA = "samplerData";
    protected static final String TAG_RESPONSE_FILE = "responseFile";
    private static final String ATT_BYTES = "by";
    private static final String ATT_SENT_BYTES = "sby";
    private static final String ATT_DATA_ENCODING = "de";
    private static final String ATT_DATA_TYPE = "dt";
    private static final String ATT_ERROR_COUNT = "ec";
    private static final String ATT_HOSTNAME = "hn";
    private static final String ATT_LABEL = "lb";
    private static final String ATT_LATENCY = "lt";
    private static final String ATT_CONNECT_TIME = "ct";
    private static final String ATT_ALL_THRDS = "na";
    private static final String ATT_GRP_THRDS = "ng";
    private static final String ATT_RESPONSE_CODE = "rc";
    private static final String ATT_RESPONSE_MESSAGE = "rm";
    private static final String ATT_RESPONSE_CODE_OLD = "rs";
    private static final String ATT_SUCCESS = "s";
    private static final String ATT_SAMPLE_COUNT = "sc";
    private static final String ATT_TIME = "t";
    private static final String ATT_IDLETIME = "it";
    private static final String ATT_THREADNAME = "tn";
    private static final String ATT_TIME_STAMP = "ts";

    public static String getVersion() {
        return "$Revision$";
    }

    @Override
    public boolean canConvert(Class arg0) {
        return SampleResult.class.equals((Object)arg0);
    }

    @Override
    public void marshal(Object obj, HierarchicalStreamWriter writer, MarshallingContext context) {
        SampleResult res = (SampleResult)obj;
        SampleSaveConfiguration save = res.getSaveConfig();
        this.setAttributes(writer, context, res, save);
        this.saveAssertions(writer, context, res, save);
        this.saveSubResults(writer, context, res, save);
        this.saveResponseHeaders(writer, context, res, save);
        this.saveRequestHeaders(writer, context, res, save);
        this.saveResponseData(writer, context, res, save);
        this.saveSamplerData(writer, context, res, save);
    }

    protected void saveSamplerData(HierarchicalStreamWriter writer, MarshallingContext context, SampleResult res, SampleSaveConfiguration save) {
        URL url;
        if (save.saveSamplerData(res)) {
            this.writeString(writer, TAG_SAMPLER_DATA, res.getSamplerData());
        }
        if (save.saveUrl() && (url = res.getURL()) != null) {
            this.writeCompleteItem(url, context, writer);
        }
    }

    protected void saveResponseData(HierarchicalStreamWriter writer, MarshallingContext context, SampleResult res, SampleSaveConfiguration save) {
        if (save.saveResponseData(res)) {
            writer.startNode(TAG_RESPONSE_DATA);
            writer.addAttribute(ATT_CLASS, JAVA_LANG_STRING);
            try {
                if ("text".equals(res.getDataType())) {
                    writer.setValue(new String(res.getResponseData(), res.getDataEncodingWithDefault()));
                } else {
                    writer.setValue("Non-TEXT response data, cannot record: (" + res.getDataType() + ")");
                }
            }
            catch (UnsupportedEncodingException e) {
                writer.setValue("Unsupported encoding in response data, cannot record: " + e);
            }
            writer.endNode();
        }
        if (save.saveFileName()) {
            writer.startNode(TAG_RESPONSE_FILE);
            writer.addAttribute(ATT_CLASS, JAVA_LANG_STRING);
            writer.setValue(res.getResultFileName());
            writer.endNode();
        }
    }

    protected void saveRequestHeaders(HierarchicalStreamWriter writer, MarshallingContext context, SampleResult res, SampleSaveConfiguration save) {
        if (save.saveRequestHeaders()) {
            this.writeString(writer, TAG_REQUEST_HEADER, res.getRequestHeaders());
        }
    }

    protected void saveResponseHeaders(HierarchicalStreamWriter writer, MarshallingContext context, SampleResult res, SampleSaveConfiguration save) {
        if (save.saveResponseHeaders()) {
            this.writeString(writer, TAG_RESPONSE_HEADER, res.getResponseHeaders());
        }
    }

    protected void saveSubResults(HierarchicalStreamWriter writer, MarshallingContext context, SampleResult res, SampleSaveConfiguration save) {
        if (save.saveSubresults()) {
            SampleResult[] subResults;
            for (SampleResult subResult : subResults = res.getSubResults()) {
                subResult.setSaveConfig(save);
                this.writeCompleteItem(subResult, context, writer);
            }
        }
    }

    protected void saveAssertions(HierarchicalStreamWriter writer, MarshallingContext context, SampleResult res, SampleSaveConfiguration save) {
        if (save.saveAssertions()) {
            AssertionResult[] assertionResults;
            for (AssertionResult assertionResult : assertionResults = res.getAssertionResults()) {
                this.writeCompleteItem(assertionResult, context, writer);
            }
        }
    }

    protected void setAttributes(HierarchicalStreamWriter writer, MarshallingContext context, SampleResult res, SampleSaveConfiguration save) {
        SampleEvent event;
        if (save.saveTime()) {
            writer.addAttribute(ATT_TIME, Long.toString(res.getTime()));
        }
        if (save.saveIdleTime()) {
            writer.addAttribute(ATT_IDLETIME, Long.toString(res.getIdleTime()));
        }
        if (save.saveLatency()) {
            writer.addAttribute(ATT_LATENCY, Long.toString(res.getLatency()));
        }
        if (save.saveConnectTime()) {
            writer.addAttribute(ATT_CONNECT_TIME, Long.toString(res.getConnectTime()));
        }
        if (save.saveTimestamp()) {
            writer.addAttribute(ATT_TIME_STAMP, Long.toString(res.getTimeStamp()));
        }
        if (save.saveSuccess()) {
            writer.addAttribute(ATT_SUCCESS, Boolean.toString(res.isSuccessful()));
        }
        if (save.saveLabel()) {
            writer.addAttribute(ATT_LABEL, ConversionHelp.encode(res.getSampleLabel()));
        }
        if (save.saveCode()) {
            writer.addAttribute(ATT_RESPONSE_CODE, ConversionHelp.encode(res.getResponseCode()));
        }
        if (save.saveMessage()) {
            writer.addAttribute(ATT_RESPONSE_MESSAGE, ConversionHelp.encode(res.getResponseMessage()));
        }
        if (save.saveThreadName()) {
            writer.addAttribute(ATT_THREADNAME, ConversionHelp.encode(res.getThreadName()));
        }
        if (save.saveDataType()) {
            writer.addAttribute(ATT_DATA_TYPE, ConversionHelp.encode(res.getDataType()));
        }
        if (save.saveEncoding()) {
            writer.addAttribute(ATT_DATA_ENCODING, ConversionHelp.encode(res.getDataEncodingNoDefault()));
        }
        if (save.saveBytes()) {
            writer.addAttribute(ATT_BYTES, String.valueOf(res.getBytesAsLong()));
        }
        if (save.saveSentBytes()) {
            writer.addAttribute(ATT_SENT_BYTES, String.valueOf(res.getSentBytes()));
        }
        if (save.saveSampleCount()) {
            writer.addAttribute(ATT_SAMPLE_COUNT, String.valueOf(res.getSampleCount()));
            writer.addAttribute(ATT_ERROR_COUNT, String.valueOf(res.getErrorCount()));
        }
        if (save.saveThreadCounts()) {
            writer.addAttribute(ATT_GRP_THRDS, String.valueOf(res.getGroupThreads()));
            writer.addAttribute(ATT_ALL_THRDS, String.valueOf(res.getAllThreads()));
        }
        if ((event = (SampleEvent)context.get("SampleEvent")) != null) {
            if (save.saveHostname()) {
                writer.addAttribute(ATT_HOSTNAME, event.getHostname());
            }
            for (int i = 0; i < SampleEvent.getVarCount(); ++i) {
                writer.addAttribute(SampleEvent.getVarName(i), ConversionHelp.encode(event.getVarValue(i)));
            }
        }
    }

    protected void writeString(HierarchicalStreamWriter writer, String tag, String value) {
        if (value != null) {
            writer.startNode(tag);
            writer.addAttribute(ATT_CLASS, JAVA_LANG_STRING);
            writer.setValue(value);
            writer.endNode();
        }
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        SampleResult res = (SampleResult)this.createCollection(context.getRequiredType());
        this.retrieveAttributes(reader, context, res);
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            Object subItem = this.readBareItem(reader, context, res);
            this.retrieveItem(reader, context, res, subItem);
            reader.moveUp();
        }
        String resultFileName = res.getResultFileName();
        if (resultFileName.length() > 0 && res.getResponseData().length == 0) {
            this.readFile(resultFileName, res);
        }
        return res;
    }

    protected boolean retrieveItem(HierarchicalStreamReader reader, UnmarshallingContext context, SampleResult res, Object subItem) {
        String nodeName = reader.getNodeName();
        if (subItem instanceof AssertionResult) {
            res.addAssertionResult((AssertionResult)subItem);
        } else if (subItem instanceof SampleResult) {
            res.storeSubResult((SampleResult)subItem, false);
        } else if (nodeName.equals(TAG_RESPONSE_HEADER)) {
            res.setResponseHeaders((String)subItem);
        } else if (nodeName.equals(TAG_REQUEST_HEADER)) {
            res.setRequestHeaders((String)subItem);
        } else if (nodeName.equals(TAG_RESPONSE_DATA)) {
            String responseData = (String)subItem;
            if (responseData.length() > 0) {
                String dataEncoding = res.getDataEncodingWithDefault();
                try {
                    res.setResponseData(responseData.getBytes(dataEncoding));
                }
                catch (UnsupportedEncodingException e) {
                    res.setResponseData("Can't support the char set: " + dataEncoding, null);
                    res.setDataType("text");
                }
            }
        } else if (nodeName.equals(TAG_SAMPLER_DATA)) {
            res.setSamplerData((String)subItem);
        } else if (nodeName.equals(TAG_RESPONSE_FILE)) {
            res.setResultFileName((String)subItem);
        } else {
            return false;
        }
        return true;
    }

    protected void retrieveAttributes(HierarchicalStreamReader reader, UnmarshallingContext context, SampleResult res) {
        res.setSampleLabel(ConversionHelp.decode(reader.getAttribute(ATT_LABEL)));
        res.setDataEncoding(ConversionHelp.decode(reader.getAttribute(ATT_DATA_ENCODING)));
        res.setDataType(ConversionHelp.decode(reader.getAttribute(ATT_DATA_TYPE)));
        String oldrc = reader.getAttribute(ATT_RESPONSE_CODE_OLD);
        if (oldrc != null) {
            res.setResponseCode(ConversionHelp.decode(oldrc));
        } else {
            res.setResponseCode(ConversionHelp.decode(reader.getAttribute(ATT_RESPONSE_CODE)));
        }
        res.setResponseMessage(ConversionHelp.decode(reader.getAttribute(ATT_RESPONSE_MESSAGE)));
        res.setSuccessful(Converter.getBoolean(reader.getAttribute(ATT_SUCCESS), true));
        res.setThreadName(ConversionHelp.decode(reader.getAttribute(ATT_THREADNAME)));
        res.setStampAndTime(Converter.getLong(reader.getAttribute(ATT_TIME_STAMP)), Converter.getLong(reader.getAttribute(ATT_TIME)));
        res.setIdleTime(Converter.getLong(reader.getAttribute(ATT_IDLETIME)));
        res.setLatency(Converter.getLong(reader.getAttribute(ATT_LATENCY)));
        res.setConnectTime(Converter.getLong(reader.getAttribute(ATT_CONNECT_TIME)));
        res.setBytes(Converter.getLong(reader.getAttribute(ATT_BYTES)));
        res.setSentBytes(Converter.getLong(reader.getAttribute(ATT_SENT_BYTES)));
        res.setSampleCount(Converter.getInt(reader.getAttribute(ATT_SAMPLE_COUNT), 1));
        res.setErrorCount(Converter.getInt(reader.getAttribute(ATT_ERROR_COUNT), 0));
        res.setGroupThreads(Converter.getInt(reader.getAttribute(ATT_GRP_THRDS)));
        res.setAllThreads(Converter.getInt(reader.getAttribute(ATT_ALL_THRDS)));
    }

    protected void readFile(String resultFileName, SampleResult res) {
        File in = new File(resultFileName);
        try (FileInputStream fis = new FileInputStream(in);
             BufferedInputStream bis = new BufferedInputStream(fis);){
            int len;
            ByteArrayOutputStream outstream = new ByteArrayOutputStream(4096);
            byte[] buffer = new byte[4096];
            while ((len = bis.read(buffer)) > 0) {
                outstream.write(buffer, 0, len);
            }
            outstream.close();
            res.setResponseData(outstream.toByteArray());
        }
        catch (IOException e) {
            log.warn("Failed to read result file.", e);
        }
    }

    public SampleResultConverter(Mapper arg0) {
        super(arg0);
    }
}

