/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.save.converters;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.AbstractCollectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.save.converters.ConversionHelp;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestElementPropertyConverter
extends AbstractCollectionConverter {
    private static final Logger log = LoggerFactory.getLogger(TestElementPropertyConverter.class);
    private static final String HEADER_CLASSNAME = "org.apache.jmeter.protocol.http.control.Header";

    public static String getVersion() {
        return "$Revision$";
    }

    @Override
    public boolean canConvert(Class arg0) {
        return TestElementProperty.class.equals((Object)arg0);
    }

    @Override
    public void marshal(Object arg0, HierarchicalStreamWriter writer, MarshallingContext context) {
        TestElementProperty prop = (TestElementProperty)arg0;
        writer.addAttribute("name", ConversionHelp.encode(prop.getName()));
        Class<?> clazz = prop.getObjectValue().getClass();
        writer.addAttribute("elementType", this.mapper().serializedClass(clazz));
        TestElement te = (TestElement)prop.getObjectValue();
        ConversionHelp.saveSpecialProperties(te, writer);
        for (JMeterProperty jmp : prop) {
            if (ConversionHelp.isSpecialProperty(jmp.getName()) || "TestPlan.comments".equals(jmp.getName()) && jmp.getStringValue().isEmpty()) continue;
            this.writeCompleteItem(jmp, context, writer);
        }
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        try {
            TestElementProperty prop = (TestElementProperty)this.createCollection(context.getRequiredType());
            prop.setName(ConversionHelp.decode(reader.getAttribute("name")));
            String element = reader.getAttribute("elementType");
            boolean isHeader = HEADER_CLASSNAME.equals(element);
            prop.setObjectValue(this.mapper().realClass(element).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            TestElement te = (TestElement)prop.getObjectValue();
            ConversionHelp.restoreSpecialProperties(te, reader);
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                JMeterProperty subProp = (JMeterProperty)this.readBareItem(reader, context, prop);
                if (subProp != null) {
                    String name;
                    if (isHeader && "TestElement.name".equals(name = subProp.getName())) {
                        subProp.setName("Header.name");
                    }
                    prop.addProperty(subProp);
                }
                reader.moveUp();
            }
            return prop;
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
            log.error("Couldn't unmarshall TestElementProperty", e);
            return new TestElementProperty("ERROR", new ConfigTestElement());
        }
    }

    public TestElementPropertyConverter(Mapper arg0) {
        super(arg0);
    }
}

