/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testbeans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.MultiProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.util.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestBeanHelper {
    protected static final Logger log = LoggerFactory.getLogger(TestBeanHelper.class);

    public static void prepare(TestElement el) {
        if (!(el instanceof TestBean)) {
            return;
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(el.getClass());
            PropertyDescriptor[] descs = beanInfo.getPropertyDescriptors();
            if (log.isDebugEnabled()) {
                log.debug("Preparing {}", (Object)el.getClass());
            }
            for (PropertyDescriptor desc : descs) {
                Method writeMethod;
                if (TestBeanHelper.isDescriptorIgnored(desc)) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Ignoring property '{}' in {}", (Object)desc.getName(), (Object)el.getClass().getCanonicalName());
                    continue;
                }
                JMeterProperty jprop = el.getProperty(desc.getName());
                Class<?> type = desc.getPropertyType();
                Object value = TestBeanHelper.unwrapProperty(desc, jprop, type);
                if (log.isDebugEnabled()) {
                    log.debug("Setting {}={}", (Object)jprop.getName(), value);
                }
                if (value == null && type.isPrimitive() || (writeMethod = desc.getWriteMethod()) == null) continue;
                TestBeanHelper.invokeOrBailOut(el, writeMethod, new Object[]{value});
            }
        }
        catch (IntrospectionException e) {
            log.error("Couldn't set properties for {}", (Object)el.getClass(), (Object)e);
        }
        catch (UnsatisfiedLinkError ule) {
            log.error("Couldn't set properties for {}", (Object)el.getClass());
            throw ule;
        }
    }

    private static Object unwrapProperty(PropertyDescriptor desc, JMeterProperty jprop, Class<?> type) {
        Object value;
        if (jprop instanceof TestElementProperty) {
            TestElement te = ((TestElementProperty)jprop).getElement();
            if (te instanceof TestBean) {
                TestBeanHelper.prepare(te);
            }
            value = te;
        } else {
            value = jprop instanceof MultiProperty ? TestBeanHelper.unwrapCollection((MultiProperty)jprop, (String)desc.getValue("tableObject.classname")) : (jprop instanceof NullProperty && !Boolean.TRUE.equals(desc.getValue("notUndefined")) ? null : Converter.convert(jprop.getStringValue(), type));
        }
        return value;
    }

    private static Object unwrapCollection(MultiProperty prop, String type) {
        if (prop instanceof CollectionProperty) {
            ArrayList<Object> values = new ArrayList<Object>();
            for (JMeterProperty jMeterProperty : prop) {
                try {
                    values.add(TestBeanHelper.unwrapProperty(null, jMeterProperty, Class.forName(type)));
                }
                catch (Exception e) {
                    log.error("Couldn't convert object: {} to {}", prop.getObjectValue(), type, e);
                }
            }
            return values;
        }
        return null;
    }

    private static Object invokeOrBailOut(Object invokee, Method method, Object[] params) {
        try {
            return method.invoke(invokee, params);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new Error(TestBeanHelper.createMessage(invokee, method, params), e);
        }
    }

    private static String createMessage(Object invokee, Method method, Object[] params) {
        StringBuilder sb = new StringBuilder();
        sb.append("This should never happen. Tried to invoke:\n");
        sb.append(invokee.getClass().getName());
        sb.append("#");
        sb.append(method.getName());
        sb.append("(");
        for (Object o : params) {
            if (o != null) {
                sb.append(o.getClass().getSimpleName());
                sb.append(' ');
            }
            sb.append(o);
            sb.append(' ');
        }
        sb.append(")");
        return sb.toString();
    }

    public static boolean isDescriptorIgnored(PropertyDescriptor descriptor) {
        return descriptor.isHidden() || descriptor.isExpert() && !JMeterUtils.isExpertMode() || descriptor.getReadMethod() == null || descriptor.getWriteMethod() == null;
    }
}

