/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.thinktime;

import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.thinktime.ThinkTimeCreator;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.sampler.TestAction;
import org.apache.jmeter.sampler.gui.TestActionGui;
import org.apache.jmeter.timers.RandomTimer;
import org.apache.jmeter.timers.gui.UniformRandomTimerGui;
import org.apache.jmeter.util.JMeterUtils;

public class DefaultThinkTimeCreator
implements ThinkTimeCreator {
    private static final String DEFAULT_TIMER_IMPLEMENTATION = JMeterUtils.getPropDefault("think_time_creator.default_timer_implementation", UniformRandomTimerGui.class.getName());
    private static final String DEFAULT_PAUSE = JMeterUtils.getPropDefault("think_time_creator.default_constant_pause", "1000");
    private static final String DEFAULT_RANGE = JMeterUtils.getPropDefault("think_time_creator.default_range", "100");

    @Override
    public JMeterTreeNode[] createThinkTime(GuiPackage guiPackage, JMeterTreeNode parentNode) throws IllegalUserActionException {
        TestAction testAction = (TestAction)guiPackage.createTestElement(TestActionGui.class.getName());
        testAction.setAction(1);
        testAction.setDuration("0");
        JMeterTreeNode thinkTimeNode = new JMeterTreeNode(testAction, guiPackage.getTreeModel());
        thinkTimeNode.setName("Think Time");
        RandomTimer randomTimer = (RandomTimer)guiPackage.createTestElement(DEFAULT_TIMER_IMPLEMENTATION);
        randomTimer.setDelay(DEFAULT_PAUSE);
        randomTimer.setRange(DEFAULT_RANGE);
        randomTimer.setName("Pause");
        JMeterTreeNode urtNode = new JMeterTreeNode(randomTimer, guiPackage.getTreeModel());
        return new JMeterTreeNode[]{thinkTimeNode, urtNode};
    }
}

