/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.control.IteratingController;
import org.apache.jmeter.control.TransactionSampler;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.engine.event.LoopIterationListener;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.processor.PostProcessor;
import org.apache.jmeter.processor.PreProcessor;
import org.apache.jmeter.samplers.Interruptible;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.SampleMonitor;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testbeans.TestBeanHelper;
import org.apache.jmeter.testelement.AbstractScopedAssertion;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestIterationListener;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.threads.FindTestElementsUpToRootTraverser;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterThreadMonitor;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.threads.ListenerNotifier;
import org.apache.jmeter.threads.SamplePackage;
import org.apache.jmeter.threads.TestCompiler;
import org.apache.jmeter.timers.Timer;
import org.apache.jmeter.timers.TimerService;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apache.jorphan.collections.ListedHashTree;
import org.apache.jorphan.collections.SearchByClass;
import org.apache.jorphan.util.JMeterError;
import org.apache.jorphan.util.JMeterStopTestException;
import org.apache.jorphan.util.JMeterStopTestNowException;
import org.apache.jorphan.util.JMeterStopThreadException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMeterThread
implements Runnable,
Interruptible {
    private static final Logger log = LoggerFactory.getLogger(JMeterThread.class);
    public static final String PACKAGE_OBJECT = "JMeterThread.pack";
    public static final String LAST_SAMPLE_OK = "JMeterThread.last_sample_ok";
    private static final String TRUE = Boolean.toString(true);
    private static final int RAMPUP_GRANULARITY = JMeterUtils.getPropDefault("jmeterthread.rampup.granularity", 1000);
    private static final float TIMER_FACTOR = JMeterUtils.getPropDefault("timer.factor", 1.0f);
    private static final TimerService TIMER_SERVICE = TimerService.getInstance();
    private static final float ONE_AS_FLOAT = 1.0f;
    private static final boolean APPLY_TIMER_FACTOR = Float.compare(TIMER_FACTOR, 1.0f) != 0;
    private final Controller threadGroupLoopController;
    private final HashTree testTree;
    private final TestCompiler compiler;
    private final JMeterThreadMonitor monitor;
    private final JMeterVariables threadVars;
    private final Collection<TestIterationListener> testIterationStartListeners;
    private final Collection<SampleMonitor> sampleMonitors;
    private final ListenerNotifier notifier;
    private String threadName;
    private int initialDelay = 0;
    private int threadNum = 0;
    private long startTime = 0L;
    private long endTime = 0L;
    private final boolean isSameUserOnNextIteration;
    private boolean scheduler = false;
    private AbstractThreadGroup threadGroup;
    private StandardJMeterEngine engine = null;
    private volatile boolean running;
    private volatile boolean onErrorStopTest;
    private volatile boolean onErrorStopTestNow;
    private volatile boolean onErrorStopThread;
    private volatile boolean onErrorStartNextLoop;
    private volatile Sampler currentSamplerForInterruption;
    private final ReentrantLock interruptLock = new ReentrantLock();

    public JMeterThread(HashTree test, JMeterThreadMonitor monitor, ListenerNotifier note) {
        this(test, monitor, note, false);
    }

    public JMeterThread(HashTree test, JMeterThreadMonitor monitor, ListenerNotifier note, Boolean isSameUserOnNextIteration) {
        this.monitor = monitor;
        this.threadVars = new JMeterVariables();
        this.testTree = test;
        this.compiler = new TestCompiler(this.testTree);
        this.threadGroupLoopController = (Controller)this.testTree.getArray()[0];
        SearchByClass<TestIterationListener> threadListenerSearcher = new SearchByClass<TestIterationListener>(TestIterationListener.class);
        test.traverse(threadListenerSearcher);
        this.testIterationStartListeners = threadListenerSearcher.getSearchResults();
        SearchByClass<SampleMonitor> sampleMonitorSearcher = new SearchByClass<SampleMonitor>(SampleMonitor.class);
        test.traverse(sampleMonitorSearcher);
        this.sampleMonitors = sampleMonitorSearcher.getSearchResults();
        this.notifier = note;
        this.running = true;
        this.isSameUserOnNextIteration = isSameUserOnNextIteration;
    }

    public void setInitialContext(JMeterContext context) {
        this.threadVars.putAll(context.getVariables());
    }

    public void setScheduled(boolean sche) {
        this.scheduler = sche;
    }

    public void setStartTime(long stime) {
        this.startTime = stime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setEndTime(long etime) {
        this.endTime = etime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    private void stopSchedulerIfNeeded() {
        long now = System.currentTimeMillis();
        if (now >= this.endTime) {
            this.running = false;
            log.info("Stopping because end time detected by thread: {}", (Object)this.threadName);
        }
    }

    private void startScheduler() {
        long delay = this.startTime - System.currentTimeMillis();
        this.delayBy(delay, "startScheduler");
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        JMeterContext threadContext = JMeterContextService.getContext();
        IterationListener iterationListener = null;
        try {
            iterationListener = this.initRun(threadContext);
            while (this.running) {
                Sampler sam = this.threadGroupLoopController.next();
                while (this.running && sam != null) {
                    this.processSampler(sam, null, threadContext);
                    threadContext.cleanAfterSample();
                    boolean lastSampleOk = TRUE.equals(threadContext.getVariables().get(LAST_SAMPLE_OK));
                    if (threadContext.getTestLogicalAction() != JMeterContext.TestLogicalAction.CONTINUE || this.onErrorStartNextLoop && !lastSampleOk) {
                        if (log.isDebugEnabled() && this.onErrorStartNextLoop && threadContext.getTestLogicalAction() != JMeterContext.TestLogicalAction.CONTINUE) {
                            log.debug("Start Next Thread Loop option is on, Last sample failed, starting next thread loop");
                        }
                        if (this.onErrorStartNextLoop && !lastSampleOk) {
                            this.triggerLoopLogicalActionOnParentControllers(sam, threadContext, JMeterThread::continueOnThreadLoop);
                        } else {
                            switch (threadContext.getTestLogicalAction()) {
                                case BREAK_CURRENT_LOOP: {
                                    this.triggerLoopLogicalActionOnParentControllers(sam, threadContext, JMeterThread::breakOnCurrentLoop);
                                    break;
                                }
                                case START_NEXT_ITERATION_OF_THREAD: {
                                    this.triggerLoopLogicalActionOnParentControllers(sam, threadContext, JMeterThread::continueOnThreadLoop);
                                    break;
                                }
                                case START_NEXT_ITERATION_OF_CURRENT_LOOP: {
                                    this.triggerLoopLogicalActionOnParentControllers(sam, threadContext, JMeterThread::continueOnCurrentLoop);
                                    break;
                                }
                            }
                        }
                        threadContext.setTestLogicalAction(JMeterContext.TestLogicalAction.CONTINUE);
                        sam = null;
                        this.setLastSampleOk(threadContext.getVariables(), true);
                        continue;
                    }
                    sam = this.threadGroupLoopController.next();
                }
                if (!this.threadGroupLoopController.isDone()) continue;
                this.running = false;
                log.info("Thread is done: {}", (Object)this.threadName);
            }
        }
        catch (JMeterStopTestException e) {
            if (log.isInfoEnabled()) {
                log.info("Stopping Test: {}", (Object)e.toString());
            }
            this.shutdownTest();
        }
        catch (JMeterStopTestNowException e) {
            if (log.isInfoEnabled()) {
                log.info("Stopping Test Now: {}", (Object)e.toString());
            }
            this.stopTestNow();
        }
        catch (JMeterStopThreadException e) {
            if (log.isInfoEnabled()) {
                log.info("Stop Thread seen for thread {}, reason: {}", (Object)this.getThreadName(), (Object)e.toString());
            }
        }
        catch (Exception | JMeterError e) {
            log.error("Test failed!", e);
        }
        catch (ThreadDeath e) {
            throw e;
        }
        finally {
            this.currentSamplerForInterruption = null;
            this.interruptLock.lock();
            try {
                threadContext.clear();
                log.info("Thread finished: {}", (Object)this.threadName);
                this.threadFinished(iterationListener);
                this.monitor.threadFinished(this);
                JMeterContextService.removeContext();
            }
            finally {
                this.interruptLock.unlock();
            }
        }
    }

    private void triggerLoopLogicalActionOnParentControllers(Sampler sampler, JMeterContext threadContext, Consumer<FindTestElementsUpToRootTraverser> consumer) {
        Sampler realSampler;
        TransactionSampler transactionSampler = null;
        if (sampler instanceof TransactionSampler) {
            transactionSampler = (TransactionSampler)sampler;
        }
        if ((realSampler = this.findRealSampler(sampler)) == null) {
            throw new IllegalStateException("Got null subSampler calling findRealSampler for:" + (sampler != null ? sampler.getName() : "null") + ", sampler:" + sampler);
        }
        FindTestElementsUpToRootTraverser pathToRootTraverser = new FindTestElementsUpToRootTraverser(realSampler);
        this.testTree.traverse(pathToRootTraverser);
        consumer.accept(pathToRootTraverser);
        if (transactionSampler != null) {
            SamplePackage transactionPack = this.compiler.configureTransactionSampler(transactionSampler);
            this.doEndTransactionSampler(transactionSampler, null, transactionPack, threadContext);
        }
    }

    private static void continueOnCurrentLoop(FindTestElementsUpToRootTraverser pathToRootTraverser) {
        List<Controller> controllersToReinit = pathToRootTraverser.getControllersToRoot();
        for (Controller parentController : controllersToReinit) {
            if (parentController instanceof AbstractThreadGroup) {
                AbstractThreadGroup tg = (AbstractThreadGroup)parentController;
                tg.startNextLoop();
                continue;
            }
            if (parentController instanceof IteratingController) {
                ((IteratingController)((Object)parentController)).startNextLoop();
                break;
            }
            parentController.triggerEndOfLoop();
        }
    }

    private static void breakOnCurrentLoop(FindTestElementsUpToRootTraverser pathToRootTraverser) {
        List<Controller> controllersToReinit = pathToRootTraverser.getControllersToRoot();
        for (Controller parentController : controllersToReinit) {
            if (parentController instanceof AbstractThreadGroup) {
                AbstractThreadGroup tg = (AbstractThreadGroup)parentController;
                tg.breakThreadLoop();
                continue;
            }
            if (parentController instanceof IteratingController) {
                ((IteratingController)((Object)parentController)).breakLoop();
                break;
            }
            parentController.triggerEndOfLoop();
        }
    }

    private static void continueOnThreadLoop(FindTestElementsUpToRootTraverser pathToRootTraverser) {
        List<Controller> controllersToReinit = pathToRootTraverser.getControllersToRoot();
        for (Controller parentController : controllersToReinit) {
            if (parentController instanceof AbstractThreadGroup) {
                AbstractThreadGroup tg = (AbstractThreadGroup)parentController;
                tg.startNextLoop();
                continue;
            }
            parentController.triggerEndOfLoop();
        }
    }

    private Sampler findRealSampler(Sampler sampler) {
        Sampler realSampler = sampler;
        while (realSampler instanceof TransactionSampler) {
            realSampler = ((TransactionSampler)realSampler).getSubSampler();
        }
        return realSampler;
    }

    private SampleResult processSampler(Sampler current, Sampler parent, JMeterContext threadContext) {
        SampleResult transactionResult = null;
        TransactionSampler transactionSampler = null;
        SamplePackage transactionPack = null;
        try {
            if (current instanceof TransactionSampler) {
                transactionSampler = (TransactionSampler)current;
                transactionPack = this.compiler.configureTransactionSampler(transactionSampler);
                if (transactionSampler.isTransactionDone()) {
                    transactionResult = this.doEndTransactionSampler(transactionSampler, parent, transactionPack, threadContext);
                    current = null;
                } else {
                    Sampler prev = current;
                    current = transactionSampler.getSubSampler();
                    if (current instanceof TransactionSampler) {
                        SampleResult res = this.processSampler(current, prev, threadContext);
                        threadContext.setCurrentSampler(prev);
                        current = null;
                        if (res != null) {
                            transactionSampler.addSubSamplerResult(res);
                        }
                    }
                }
            }
            if (current != null) {
                this.executeSamplePackage(current, transactionSampler, transactionPack, threadContext);
            }
            if (this.scheduler) {
                this.stopSchedulerIfNeeded();
            }
        }
        catch (JMeterStopTestException e) {
            if (log.isInfoEnabled()) {
                log.info("Stopping Test: {}", (Object)e.toString());
            }
            this.shutdownTest();
        }
        catch (JMeterStopTestNowException e) {
            if (log.isInfoEnabled()) {
                log.info("Stopping Test with interruption of current samplers: {}", (Object)e.toString());
            }
            this.stopTestNow();
        }
        catch (JMeterStopThreadException e) {
            if (log.isInfoEnabled()) {
                log.info("Stopping Thread: {}", (Object)e.toString());
            }
            this.stopThread();
        }
        catch (Exception e) {
            if (current != null) {
                log.error("Error while processing sampler: '{}'.", (Object)current.getName(), (Object)e);
            }
            log.error("Error while processing sampler.", e);
        }
        if (!this.running && transactionResult == null && transactionSampler != null && transactionPack != null) {
            transactionResult = this.doEndTransactionSampler(transactionSampler, parent, transactionPack, threadContext);
        }
        return transactionResult;
    }

    private void fillThreadInformation(SampleResult result, int nbActiveThreadsInThreadGroup, int nbTotalActiveThreads) {
        result.setGroupThreads(nbActiveThreadsInThreadGroup);
        result.setAllThreads(nbTotalActiveThreads);
        result.setThreadName(this.threadName);
    }

    private void executeSamplePackage(Sampler current, TransactionSampler transactionSampler, SamplePackage transactionPack, JMeterContext threadContext) {
        threadContext.setCurrentSampler(current);
        SamplePackage pack = this.compiler.configureSampler(current);
        this.runPreProcessors(pack.getPreProcessors());
        this.threadVars.putObject(PACKAGE_OBJECT, pack);
        this.delay(pack.getTimers());
        SampleResult result = null;
        if (this.running) {
            Sampler sampler = pack.getSampler();
            result = this.doSampling(threadContext, sampler);
        }
        if (result != null) {
            if (!result.isIgnore()) {
                int nbActiveThreadsInThreadGroup = this.threadGroup.getNumberOfThreads();
                int nbTotalActiveThreads = JMeterContextService.getNumberOfThreads();
                this.fillThreadInformation(result, nbActiveThreadsInThreadGroup, nbTotalActiveThreads);
                SampleResult[] subResults = result.getSubResults();
                if (subResults != null) {
                    for (SampleResult subResult : subResults) {
                        this.fillThreadInformation(subResult, nbActiveThreadsInThreadGroup, nbTotalActiveThreads);
                    }
                }
                threadContext.setPreviousResult(result);
                this.runPostProcessors(pack.getPostProcessors());
                this.checkAssertions(pack.getAssertions(), result, threadContext);
                if (!result.isIgnore()) {
                    List<SampleListener> sampleListeners = this.getSampleListeners(pack, transactionPack, transactionSampler);
                    this.notifyListeners(sampleListeners, result);
                }
                this.compiler.done(pack);
                if (transactionSampler != null && !result.isIgnore()) {
                    transactionSampler.addSubSamplerResult(result);
                }
            } else {
                this.setLastSampleOk(threadContext.getVariables(), result.isSuccessful());
            }
            if (result.isStopThread() || !result.isSuccessful() && this.onErrorStopThread) {
                this.stopThread();
            }
            if (result.isStopTest() || !result.isSuccessful() && this.onErrorStopTest) {
                this.shutdownTest();
            }
            if (result.isStopTestNow() || !result.isSuccessful() && this.onErrorStopTestNow) {
                this.stopTestNow();
            }
            if (result.getTestLogicalAction() != JMeterContext.TestLogicalAction.CONTINUE) {
                threadContext.setTestLogicalAction(result.getTestLogicalAction());
            }
        } else {
            this.compiler.done(pack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SampleResult doSampling(JMeterContext threadContext, Sampler sampler) {
        sampler.setThreadContext(threadContext);
        sampler.setThreadName(this.threadName);
        TestBeanHelper.prepare(sampler);
        this.currentSamplerForInterruption = sampler;
        if (!this.sampleMonitors.isEmpty()) {
            for (SampleMonitor sampleMonitor : this.sampleMonitors) {
                if (sampleMonitor instanceof TestElement) {
                    TestBeanHelper.prepare((TestElement)((Object)sampleMonitor));
                }
                sampleMonitor.sampleStarting(sampler);
            }
        }
        try {
            SampleResult sampleResult = sampler.sample(null);
            return sampleResult;
        }
        finally {
            if (!this.sampleMonitors.isEmpty()) {
                for (SampleMonitor sampleMonitor : this.sampleMonitors) {
                    sampleMonitor.sampleEnded(sampler);
                }
            }
            this.currentSamplerForInterruption = null;
        }
    }

    private SampleResult doEndTransactionSampler(TransactionSampler transactionSampler, Sampler parent, SamplePackage transactionPack, JMeterContext threadContext) {
        SampleResult transactionResult = transactionSampler.getTransactionResult();
        this.fillThreadInformation(transactionResult, this.threadGroup.getNumberOfThreads(), JMeterContextService.getNumberOfThreads());
        this.checkAssertions(transactionPack.getAssertions(), transactionResult, threadContext);
        if (!(parent instanceof TransactionSampler)) {
            this.notifyListeners(transactionPack.getSampleListeners(), transactionResult);
        }
        this.compiler.done(transactionPack);
        return transactionResult;
    }

    private List<SampleListener> getSampleListeners(SamplePackage samplePack, SamplePackage transactionPack, TransactionSampler transactionSampler) {
        List<SampleListener> sampleListeners = samplePack.getSampleListeners();
        if (transactionSampler != null) {
            ArrayList<SampleListener> onlySubSamplerListeners = new ArrayList<SampleListener>();
            List<SampleListener> transListeners = transactionPack.getSampleListeners();
            for (SampleListener listener : sampleListeners) {
                boolean found = false;
                for (SampleListener trans : transListeners) {
                    if (trans != listener) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                onlySubSamplerListeners.add(listener);
            }
            sampleListeners = onlySubSamplerListeners;
        }
        return sampleListeners;
    }

    private void setLastSampleOk(JMeterVariables variables, boolean value) {
        variables.put(LAST_SAMPLE_OK, Boolean.toString(value));
    }

    private IterationListener initRun(JMeterContext threadContext) {
        this.threadVars.putObject("__jmv_SAME_USER", this.isSameUserOnNextIteration);
        threadContext.setVariables(this.threadVars);
        threadContext.setThreadNum(this.getThreadNum());
        this.setLastSampleOk(this.threadVars, true);
        threadContext.setThread(this);
        threadContext.setThreadGroup(this.threadGroup);
        threadContext.setEngine(this.engine);
        this.testTree.traverse(this.compiler);
        if (this.scheduler) {
            this.startScheduler();
        }
        this.rampUpDelay();
        if (log.isInfoEnabled()) {
            log.info("Thread started: {}", (Object)Thread.currentThread().getName());
        }
        threadContext.setSamplingStarted(true);
        this.threadGroupLoopController.initialize();
        IterationListener iterationListener = new IterationListener();
        this.threadGroupLoopController.addIterationListener(iterationListener);
        this.threadStarted();
        return iterationListener;
    }

    private void threadStarted() {
        JMeterContextService.incrNumberOfThreads();
        this.threadGroup.incrNumberOfThreads();
        GuiPackage gp = GuiPackage.getInstance();
        if (gp != null) {
            gp.getMainFrame().updateCounts();
        }
        ThreadListenerTraverser startup = new ThreadListenerTraverser(true);
        this.testTree.traverse(startup);
    }

    private void threadFinished(LoopIterationListener iterationListener) {
        ThreadListenerTraverser shut = new ThreadListenerTraverser(false);
        this.testTree.traverse(shut);
        JMeterContextService.decrNumberOfThreads();
        this.threadGroup.decrNumberOfThreads();
        GuiPackage gp = GuiPackage.getInstance();
        if (gp != null) {
            gp.getMainFrame().updateCounts();
        }
        if (iterationListener != null) {
            this.threadGroupLoopController.removeIterationListener(iterationListener);
        }
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void stop() {
        this.running = false;
        log.info("Stopping: {}", (Object)this.threadName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean interrupt() {
        this.interruptLock.lock();
        try {
            Sampler samp = this.currentSamplerForInterruption;
            if (samp instanceof Interruptible) {
                if (log.isWarnEnabled()) {
                    log.warn("Interrupting: {} sampler: {}", (Object)this.threadName, (Object)samp.getName());
                }
                try {
                    boolean found = ((Interruptible)((Object)samp)).interrupt();
                    if (!found) {
                        log.warn("No operation pending");
                    }
                    boolean bl = found;
                    return bl;
                }
                catch (Exception e) {
                    if (log.isWarnEnabled()) {
                        log.warn("Caught Exception interrupting sampler: {}", (Object)e.toString());
                    }
                }
            } else if (samp != null && log.isWarnEnabled()) {
                log.warn("Sampler is not Interruptible: {}", (Object)samp.getName());
            }
        }
        finally {
            this.interruptLock.unlock();
        }
        return false;
    }

    private void shutdownTest() {
        this.running = false;
        log.info("Shutdown Test detected by thread: {}", (Object)this.threadName);
        if (this.engine != null) {
            this.engine.askThreadsToStop();
        }
    }

    private void stopTestNow() {
        this.running = false;
        log.info("Stop Test Now detected by thread: {}", (Object)this.threadName);
        if (this.engine != null) {
            this.engine.stopTest();
        }
    }

    private void stopThread() {
        this.running = false;
        log.info("Stop Thread detected by thread: {}", (Object)this.threadName);
    }

    private void checkAssertions(List<Assertion> assertions, SampleResult parent, JMeterContext threadContext) {
        for (Assertion assertion : assertions) {
            TestBeanHelper.prepare((TestElement)((Object)assertion));
            if (assertion instanceof AbstractScopedAssertion) {
                AbstractScopedAssertion scopedAssertion = (AbstractScopedAssertion)((Object)assertion);
                String scope = scopedAssertion.fetchScope();
                if (scopedAssertion.isScopeParent(scope) || scopedAssertion.isScopeAll(scope) || scopedAssertion.isScopeVariable(scope)) {
                    this.processAssertion(parent, assertion);
                }
                if (!scopedAssertion.isScopeChildren(scope) && !scopedAssertion.isScopeAll(scope)) continue;
                this.recurseAssertionChecks(parent, assertion, 3);
                continue;
            }
            this.processAssertion(parent, assertion);
        }
        this.setLastSampleOk(threadContext.getVariables(), parent.isSuccessful());
    }

    private void recurseAssertionChecks(SampleResult parent, Assertion assertion, int level) {
        if (level < 0) {
            return;
        }
        SampleResult[] children = parent.getSubResults();
        boolean childError = false;
        for (SampleResult childSampleResult : children) {
            this.processAssertion(childSampleResult, assertion);
            this.recurseAssertionChecks(childSampleResult, assertion, level - 1);
            if (childSampleResult.isSuccessful()) continue;
            childError = true;
        }
        if (childError && parent.isSuccessful()) {
            AssertionResult assertionResult = new AssertionResult(((AbstractTestElement)((Object)assertion)).getName());
            assertionResult.setResultForFailure("One or more sub-samples failed");
            parent.addAssertionResult(assertionResult);
            parent.setSuccessful(false);
        }
    }

    private void processAssertion(SampleResult result, Assertion assertion) {
        AssertionResult assertionResult;
        try {
            assertionResult = assertion.getResult(result);
        }
        catch (AssertionError e) {
            log.debug("Error processing Assertion.", (Throwable)((Object)e));
            assertionResult = new AssertionResult("Assertion failed! See log file (debug level, only).");
            assertionResult.setFailure(true);
            assertionResult.setFailureMessage(((Throwable)((Object)e)).toString());
        }
        catch (JMeterError e) {
            log.error("Error processing Assertion.", e);
            assertionResult = new AssertionResult("Assertion failed! See log file.");
            assertionResult.setError(true);
            assertionResult.setFailureMessage(e.toString());
        }
        catch (Exception e) {
            log.error("Exception processing Assertion.", e);
            assertionResult = new AssertionResult("Assertion failed! See log file.");
            assertionResult.setError(true);
            assertionResult.setFailureMessage(e.toString());
        }
        result.setSuccessful(result.isSuccessful() && !assertionResult.isError() && !assertionResult.isFailure());
        result.addAssertionResult(assertionResult);
    }

    private void runPostProcessors(List<PostProcessor> extractors) {
        for (PostProcessor ex : extractors) {
            TestBeanHelper.prepare((TestElement)((Object)ex));
            ex.process();
        }
    }

    private void runPreProcessors(List<PreProcessor> preProcessors) {
        for (PreProcessor ex : preProcessors) {
            if (log.isDebugEnabled()) {
                log.debug("Running preprocessor: {}", (Object)((AbstractTestElement)((Object)ex)).getName());
            }
            TestBeanHelper.prepare((TestElement)((Object)ex));
            ex.process();
        }
    }

    private void delay(List<Timer> timers) {
        long totalDelay = 0L;
        for (Timer timer : timers) {
            TestBeanHelper.prepare((TestElement)((Object)timer));
            long delay = timer.delay();
            if (APPLY_TIMER_FACTOR && timer.isModifiable()) {
                if (log.isDebugEnabled()) {
                    log.debug("Applying TIMER_FACTOR:{} on timer:{} for thread:{}", Float.valueOf(TIMER_FACTOR), ((TestElement)((Object)timer)).getName(), this.getThreadName());
                }
                delay = Math.round((float)delay * TIMER_FACTOR);
            }
            totalDelay += delay;
        }
        if (totalDelay > 0L) {
            try {
                if (this.scheduler && (totalDelay = TIMER_SERVICE.adjustDelay(totalDelay, this.endTime, false)) < 0L) {
                    log.debug("The delay would be longer than the scheduled period, so stop thread now.");
                    this.running = false;
                    return;
                }
                TimeUnit.MILLISECONDS.sleep(totalDelay);
            }
            catch (InterruptedException e) {
                log.warn("The delay timer was interrupted - probably did not wait as long as intended.");
                Thread.currentThread().interrupt();
            }
        }
    }

    void notifyTestListeners() {
        this.threadVars.incIteration();
        for (TestIterationListener listener : this.testIterationStartListeners) {
            listener.testIterationStart(new LoopIterationEvent(this.threadGroupLoopController, this.threadVars.getIteration()));
            if (!(listener instanceof TestElement)) continue;
            ((TestElement)((Object)listener)).recoverRunningVersion();
        }
    }

    private void notifyListeners(List<SampleListener> listeners, SampleResult result) {
        SampleEvent event = new SampleEvent(result, this.threadGroup.getName(), this.threadVars);
        this.notifier.notifyListeners(event, listeners);
    }

    public void setInitialDelay(int delay) {
        this.initialDelay = delay;
    }

    private void rampUpDelay() {
        this.delayBy(this.initialDelay, "RampUp");
    }

    protected final void delayBy(long delay, String type) {
        if (delay > 0L) {
            long now;
            long start = System.currentTimeMillis();
            long end = start + delay;
            long pause = RAMPUP_GRANULARITY;
            while (this.running && (now = System.currentTimeMillis()) < end) {
                long togo = end - now;
                if (togo < pause) {
                    pause = togo;
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(pause);
                }
                catch (InterruptedException e) {
                    if (this.running) {
                        log.warn("{} delay for {} was interrupted. Waited {} milli-seconds out of {}", type, this.threadName, now - start, delay);
                    }
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
    }

    public int getThreadNum() {
        return this.threadNum;
    }

    public void setThreadNum(int threadNum) {
        this.threadNum = threadNum;
    }

    public void setEngine(StandardJMeterEngine engine) {
        this.engine = engine;
    }

    public void setOnErrorStopTest(boolean b) {
        this.onErrorStopTest = b;
    }

    public void setOnErrorStopTestNow(boolean b) {
        this.onErrorStopTestNow = b;
    }

    public void setOnErrorStopThread(boolean b) {
        this.onErrorStopThread = b;
    }

    public void setOnErrorStartNextLoop(boolean b) {
        this.onErrorStartNextLoop = b;
    }

    public void setThreadGroup(AbstractThreadGroup group) {
        this.threadGroup = group;
    }

    public ListedHashTree getTestTree() {
        return (ListedHashTree)this.testTree;
    }

    public ListenerNotifier getNotifier() {
        return this.notifier;
    }

    private class IterationListener
    implements LoopIterationListener {
        private IterationListener() {
        }

        @Override
        public void iterationStart(LoopIterationEvent iterEvent) {
            JMeterThread.this.notifyTestListeners();
        }
    }

    static class ThreadListenerTraverser
    implements HashTreeTraverser {
        private final boolean isStart;

        ThreadListenerTraverser(boolean start) {
            this.isStart = start;
        }

        @Override
        public void addNode(Object node, HashTree subTree) {
            if (node instanceof ThreadListener) {
                ThreadListener tl = (ThreadListener)node;
                if (this.isStart) {
                    try {
                        tl.threadStarted();
                    }
                    catch (Exception e) {
                        log.error("Error calling threadStarted", e);
                    }
                } else {
                    try {
                        tl.threadFinished();
                    }
                    catch (Exception e) {
                        log.error("Error calling threadFinished", e);
                    }
                }
            }
        }

        @Override
        public void subtractNode() {
        }

        @Override
        public void processPath() {
        }
    }
}

