/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.timers;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.timers.Timer;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GUIMenuSortOrder(value=4)
@TestElementMetadata(labelResource="displayName")
public class ConstantThroughputTimer
extends AbstractTestElement
implements Timer,
TestStateListener,
TestBean {
    private static final long serialVersionUID = 4L;
    private static final Logger log = LoggerFactory.getLogger(ConstantThroughputTimer.class);
    private static final double MILLISEC_PER_MIN = 60000.0;
    private long previousTime = 0L;
    private Mode mode = Mode.ThisThreadOnly;
    private double throughput;
    private static final ThroughputInfo allThreadsInfo = new ThroughputInfo();
    private static final ConcurrentMap<AbstractThreadGroup, ThroughputInfo> threadGroupsInfoMap = new ConcurrentHashMap<AbstractThreadGroup, ThroughputInfo>();

    public void setThroughput(double throughput) {
        this.throughput = throughput;
    }

    public double getThroughput() {
        return this.throughput;
    }

    public int getCalcMode() {
        return this.mode.ordinal();
    }

    public void setCalcMode(int mode) {
        this.mode = Mode.values()[mode];
    }

    @Override
    public long delay() {
        long currentTarget;
        long currentTime = System.currentTimeMillis();
        if (currentTime > (currentTarget = this.previousTime + this.calculateDelay())) {
            this.previousTime = currentTime;
            return 0L;
        }
        this.previousTime = currentTarget;
        return currentTarget - currentTime;
    }

    protected long calculateCurrentTarget(long currentTime) {
        return currentTime + this.calculateDelay();
    }

    private long calculateDelay() {
        long delay;
        double msPerRequest = 60000.0 / this.getThroughput();
        switch (this.mode) {
            case AllActiveThreads: {
                delay = Math.round((double)JMeterContextService.getNumberOfThreads() * msPerRequest);
                break;
            }
            case AllActiveThreadsInCurrentThreadGroup: {
                delay = Math.round((double)JMeterContextService.getContext().getThreadGroup().getNumberOfThreads() * msPerRequest);
                break;
            }
            case AllActiveThreads_Shared: {
                delay = this.calculateSharedDelay(allThreadsInfo, Math.round(msPerRequest));
                break;
            }
            case AllActiveThreadsInCurrentThreadGroup_Shared: {
                ThroughputInfo previous;
                AbstractThreadGroup group = JMeterContextService.getContext().getThreadGroup();
                ThroughputInfo groupInfo = (ThroughputInfo)threadGroupsInfoMap.get(group);
                if (groupInfo == null && (previous = threadGroupsInfoMap.putIfAbsent(group, groupInfo = new ThroughputInfo())) != null) {
                    groupInfo = previous;
                }
                delay = this.calculateSharedDelay(groupInfo, Math.round(msPerRequest));
                break;
            }
            default: {
                delay = Math.round(msPerRequest);
            }
        }
        return delay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long calculateSharedDelay(ThroughputInfo info, long milliSecPerRequest) {
        long calculatedDelay;
        long now = System.currentTimeMillis();
        Object object = info.MUTEX;
        synchronized (object) {
            long nextRequestTime = info.lastScheduledTime + milliSecPerRequest;
            info.lastScheduledTime = Math.max(now, nextRequestTime);
            calculatedDelay = info.lastScheduledTime - now;
        }
        return Math.max(calculatedDelay, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        Object object = ConstantThroughputTimer.allThreadsInfo.MUTEX;
        synchronized (object) {
            ConstantThroughputTimer.allThreadsInfo.lastScheduledTime = 0L;
        }
        threadGroupsInfoMap.clear();
        this.previousTime = 0L;
    }

    public String toString() {
        return JMeterUtils.getResString("constant_throughput_timer_memo");
    }

    @Override
    public void testStarted() {
        log.debug("Test started - reset throughput calculation.");
        this.reset();
    }

    @Override
    public void setProperty(JMeterProperty property) {
        String pn;
        if (property instanceof StringProperty && (pn = property.getName()).equals("calcMode")) {
            Object objectValue = property.getObjectValue();
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(this.getClass());
                ResourceBundle rb = (ResourceBundle)beanInfo.getBeanDescriptor().getValue("resourceBundle");
                for (Mode e : Mode.values()) {
                    String propName = ((Enum)e).toString();
                    if (!objectValue.equals(rb.getObject(propName))) continue;
                    int tmpMode = e.ordinal();
                    log.debug("Converted {}={} to mode={} using Locale: {}", pn, objectValue, tmpMode, rb.getLocale());
                    super.setProperty(pn, tmpMode);
                    return;
                }
                log.warn("Could not convert {}={} using Locale: {}", pn, objectValue, rb.getLocale());
            }
            catch (IntrospectionException e) {
                log.error("Could not find BeanInfo", e);
            }
        }
        super.setProperty(property);
    }

    @Override
    public void testEnded() {
    }

    @Override
    public void testStarted(String host) {
        this.testStarted();
    }

    @Override
    public void testEnded(String host) {
    }

    Mode getMode() {
        return this.mode;
    }

    void setMode(Mode newMode) {
        this.mode = newMode;
    }

    public static enum Mode {
        ThisThreadOnly("calcMode.1"),
        AllActiveThreads("calcMode.2"),
        AllActiveThreadsInCurrentThreadGroup("calcMode.3"),
        AllActiveThreads_Shared("calcMode.4"),
        AllActiveThreadsInCurrentThreadGroup_Shared("calcMode.5");

        private final String propertyName;

        private Mode(String name) {
            this.propertyName = name;
        }

        public String toString() {
            return this.propertyName;
        }
    }

    private static class ThroughputInfo {
        final Object MUTEX = new Object();
        long lastScheduledTime = 0L;

        private ThroughputInfo() {
        }
    }
}

