/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.timers;

import java.io.IOException;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.timers.Timer;
import org.apache.jmeter.util.JSR223TestElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestElementMetadata(labelResource="displayName")
public class JSR223Timer
extends JSR223TestElement
implements Cloneable,
Timer,
TestBean {
    private static final Logger log = LoggerFactory.getLogger(JSR223Timer.class);
    private static final long serialVersionUID = 5L;

    @Override
    public long delay() {
        long delay = 0L;
        try {
            ScriptEngine scriptEngine = this.getScriptEngine();
            Object o = this.processFileOrScript(scriptEngine, null);
            if (o == null) {
                log.warn("Script did not return a value");
                return 0L;
            }
            delay = Long.parseLong(o.toString());
        }
        catch (IOException | NumberFormatException | ScriptException e) {
            log.error("Problem in JSR223 script, {}", (Object)this.getName(), (Object)e);
        }
        return delay;
    }

    @Override
    public Object clone() {
        return super.clone();
    }
}

