/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.timers.gui;

import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.timers.RandomTimer;
import org.apache.jmeter.timers.gui.AbstractTimerGui;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;

public abstract class AbstractRandomTimerGui
extends AbstractTimerGui {
    private static final long serialVersionUID = -322164502276145504L;
    private static final String DELAY_FIELD = "Delay Field";
    private static final String RANGE_FIELD = "Range Field";
    private JTextField delayField;
    private JTextField rangeField;

    protected AbstractRandomTimerGui() {
        this.init();
    }

    public static void error(Exception e, JComponent thrower) {
        JOptionPane.showMessageDialog(thrower, e, "Error", 0);
    }

    @Override
    public TestElement createTestElement() {
        RandomTimer timer = this.createRandomTimer();
        this.modifyTestElement(timer);
        return timer;
    }

    @Override
    public void modifyTestElement(TestElement timer) {
        super.configureTestElement(timer);
        ((RandomTimer)timer).setDelay(this.delayField.getText());
        ((RandomTimer)timer).setRange(this.rangeField.getText());
    }

    @Override
    public void configure(TestElement el) {
        super.configure(el);
        this.delayField.setText(el.getPropertyAsString("ConstantTimer.delay"));
        this.rangeField.setText(el.getPropertyAsString("RandomTimer.range"));
    }

    private void init() {
        this.setLayout(new VerticalLayout(5, 3));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel());
        JPanel threadDelayPropsPanel = new JPanel((LayoutManager)new MigLayout("fillx, wrap 2", "[][fill,grow]"));
        threadDelayPropsPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString("thread_delay_properties")));
        this.rangeField = new JTextField(20);
        this.rangeField.setText(this.getDefaultRange());
        threadDelayPropsPanel.add(JMeterUtils.labelFor(this.rangeField, this.getTimerRangeLabelKey(), RANGE_FIELD));
        threadDelayPropsPanel.add(this.rangeField);
        this.delayField = new JTextField(20);
        this.delayField.setText(this.getDefaultDelay());
        threadDelayPropsPanel.add(JMeterUtils.labelFor(this.delayField, this.getTimerDelayLabelKey(), DELAY_FIELD));
        threadDelayPropsPanel.add(this.delayField);
        this.add(threadDelayPropsPanel);
    }

    @Override
    public void clearGui() {
        this.rangeField.setText(this.getDefaultRange());
        this.delayField.setText(this.getDefaultDelay());
        super.clearGui();
    }

    @Override
    public abstract String getLabelResource();

    protected abstract RandomTimer createRandomTimer();

    protected abstract String getTimerDelayLabelKey();

    protected abstract String getTimerRangeLabelKey();

    protected abstract String getDefaultDelay();

    protected abstract String getDefaultRange();
}

