/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.timers.poissonarrivals;

import java.nio.DoubleBuffer;
import java.util.Arrays;
import java.util.Random;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.timers.poissonarrivals.DurationProvider;
import org.apache.jmeter.timers.poissonarrivals.EventProducer;
import org.apache.jmeter.timers.poissonarrivals.ThroughputProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstantPoissonProcessGenerator
implements EventProducer {
    private static final Logger log = LoggerFactory.getLogger(ConstantPoissonProcessGenerator.class);
    private static final double PRECISION = 1.0E-5;
    private final Random rnd = new Random();
    private final ThroughputProvider throughputProvider;
    private final int batchSize;
    private final int batchThreadDelay;
    private final DurationProvider durationProvider;
    private final boolean logFirstSamples;
    private int batchItemIndex;
    private double lastThroughput;
    private double lastThroughputDurationFinish;
    private DoubleBuffer events;

    public ConstantPoissonProcessGenerator(ThroughputProvider throughput, int batchSize, int batchThreadDelay, DurationProvider duration, Long seed, boolean logFirstSamples) {
        this.throughputProvider = throughput;
        this.batchSize = batchSize;
        this.batchThreadDelay = batchThreadDelay;
        this.durationProvider = duration;
        this.logFirstSamples = logFirstSamples;
        if (seed != null && seed.intValue() != 0) {
            this.rnd.setSeed(seed);
        }
        this.ensureCapacity(0);
    }

    private void ensureCapacity(int size) {
        if (this.events != null && this.events.capacity() >= size) {
            return;
        }
        this.events = DoubleBuffer.allocate(size);
    }

    public void generateNext() {
        double throughput;
        this.lastThroughput = throughput = this.throughputProvider.getThroughput();
        if (this.batchSize > 1) {
            throughput /= (double)this.batchSize;
        }
        this.batchItemIndex = 0;
        long duration = this.durationProvider.getDuration();
        int samples = (int)Math.ceil(throughput * (double)duration);
        this.ensureCapacity(samples);
        long t = System.currentTimeMillis();
        this.events.clear();
        for (int i = 0; i < samples; ++i) {
            this.events.put(this.lastThroughputDurationFinish + this.rnd.nextDouble() * (double)duration);
        }
        Arrays.sort(this.events.array(), this.events.arrayOffset(), this.events.position());
        t = System.currentTimeMillis() - t;
        if (t > 1000L) {
            log.warn("Spent {} ms while generating sequence of delays for {} samples, {} throughput, {} duration", t, samples, throughput, duration);
        }
        this.lastThroughputDurationFinish += (double)duration;
        if (this.logFirstSamples) {
            if (log.isDebugEnabled()) {
                log.debug("Generated {} events ({} required, rate {}) in {} ms", this.events.position(), samples, throughput, t);
            }
            if (log.isInfoEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Generated ").append(this.events.position()).append(" timings (");
                if (this.durationProvider instanceof AbstractTestElement) {
                    sb.append(((AbstractTestElement)((Object)this.durationProvider)).getName());
                }
                sb.append(" ").append(samples).append(" required, rate ").append(throughput).append(", duration ").append(duration).append(") in ").append(t).append(" ms");
                sb.append(". First 15 events will be fired at: ");
                double prev = 0.0;
                for (int i = 0; i < this.events.position() && i < 15; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    double ev = this.events.get(i);
                    sb.append(ev);
                    sb.append(" (+").append(ev - prev).append(")");
                    prev = ev;
                }
                log.info(sb.toString());
            }
        }
        this.events.flip();
    }

    @Override
    public double next() {
        if (this.batchItemIndex == 0 && !this.events.hasRemaining() || !this.valuesAreEqualWithPrecision(this.throughputProvider.getThroughput(), this.lastThroughput)) {
            this.generateNext();
        }
        if (this.batchSize == 1) {
            return this.events.get();
        }
        ++this.batchItemIndex;
        if (this.batchItemIndex == 1) {
            return this.events.get();
        }
        if (this.batchItemIndex == this.batchSize) {
            this.batchItemIndex = 0;
        }
        return this.events.get(this.events.position() - 1);
    }

    private boolean valuesAreEqualWithPrecision(double throughput, double lastThroughput) {
        return Math.abs(throughput - lastThroughput) < 1.0E-5;
    }
}

