/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import com.github.benmanes.caffeine.cache.CacheLoader;
import java.util.List;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.jmeter.util.XPathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XPathQueryCacheLoader
implements CacheLoader<ImmutablePair<String, String>, XPathExecutable> {
    private static final Logger log = LoggerFactory.getLogger(XPathQueryCacheLoader.class);

    public XPathExecutable load(ImmutablePair<String, String> key) throws Exception {
        String xPathQuery = (String)key.left;
        String namespacesString = (String)key.right;
        Processor processor = XPathUtil.getProcessor();
        XPathCompiler xPathCompiler = processor.newXPathCompiler();
        List<String[]> namespacesList = XPathUtil.namespacesParse(namespacesString);
        log.debug("Parsed namespaces:{} into list of namespaces:{}", (Object)namespacesString, (Object)namespacesList);
        for (String[] namespaces : namespacesList) {
            xPathCompiler.declareNamespace(namespaces[0], namespaces[1]);
        }
        log.debug("Declared namespaces:{}, now compiling xPathQuery:{}", (Object)namespacesList, (Object)xPathQuery);
        return xPathCompiler.compile(xPathQuery);
    }
}

