/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.gui.util.JMeterColor;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.CachingStatCalculator;
import org.apache.jmeter.visualizers.Graph;
import org.apache.jmeter.visualizers.ImageVisualizer;
import org.apache.jmeter.visualizers.Sample;
import org.apache.jmeter.visualizers.gui.AbstractVisualizer;

@TestElementMetadata(labelResource="graph_results_title")
public class GraphVisualizer
extends AbstractVisualizer
implements ImageVisualizer,
ItemListener,
Clearable {
    private static final long serialVersionUID = 240L;
    private static final String ZERO = "0";
    private final NumberFormat nf = NumberFormat.getInstance();
    private final CachingStatCalculator model;
    private JTextField maxYField = null;
    private JTextField minYField = null;
    private JTextField noSamplesField = null;
    private final String minute = JMeterUtils.getResString("minute");
    private final int REFRESH_PERIOD = JMeterUtils.getPropDefault("jmeter.gui.refresh_period", 500);
    private final Graph graph;
    private JCheckBox data;
    private JCheckBox average;
    private JCheckBox deviation;
    private JCheckBox throughput;
    private JCheckBox median;
    private JTextField dataField;
    private JTextField averageField;
    private JTextField deviationField;
    private JTextField throughputField;
    private JTextField medianField;
    private final Deque<SampleResult> newSamples = new ConcurrentLinkedDeque<SampleResult>();

    public GraphVisualizer() {
        this.model = new CachingStatCalculator("Graph");
        this.graph = new Graph(this.model);
        this.init();
    }

    @Override
    public Image getImage() {
        Image result = this.graph.createImage(this.graph.getWidth(), this.graph.getHeight());
        this.graph.paintComponent(result.getGraphics());
        return result;
    }

    @Deprecated
    public void updateGui(Sample s) {
        JMeterUtils.runSafe(false, () -> this.updateGuiInAWTThread(s));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectSamplesFromQueue() {
        Sample s = null;
        Graph graph = this.graph;
        synchronized (graph) {
            while (!this.newSamples.isEmpty()) {
                s = this.model.addSample(this.newSamples.pop());
            }
        }
        this.updateGuiInAWTThread(s);
    }

    private void updateGuiInAWTThread(Sample s) {
        if (s == null) {
            return;
        }
        this.graph.updateGui(s);
        this.noSamplesField.setText(Long.toString(s.getCount()));
        this.dataField.setText(Long.toString(s.getData()));
        this.averageField.setText(Long.toString(s.getAverage()));
        this.deviationField.setText(Long.toString(s.getDeviation()));
        this.throughputField.setText(this.nf.format(60.0 * s.getThroughput()) + "/" + this.minute);
        this.medianField.setText(Long.toString(s.getMedian()));
        this.updateYAxis();
    }

    @Override
    public void add(SampleResult res) {
        this.newSamples.add(res);
    }

    @Override
    public String getLabelResource() {
        return "graph_results_title";
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getItem() == this.data) {
            this.graph.enableData(e.getStateChange() == 1);
        } else if (e.getItem() == this.average) {
            this.graph.enableAverage(e.getStateChange() == 1);
        } else if (e.getItem() == this.deviation) {
            this.graph.enableDeviation(e.getStateChange() == 1);
        } else if (e.getItem() == this.throughput) {
            this.graph.enableThroughput(e.getStateChange() == 1);
        } else if (e.getItem() == this.median) {
            this.graph.enableMedian(e.getStateChange() == 1);
        }
        this.graph.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearData() {
        Graph graph = this.graph;
        synchronized (graph) {
            this.graph.clearData();
            this.model.clear();
            this.newSamples.clear();
        }
        this.dataField.setText(ZERO);
        this.averageField.setText(ZERO);
        this.deviationField.setText(ZERO);
        this.throughputField.setText("0/" + this.minute);
        this.medianField.setText(ZERO);
        this.noSamplesField.setText(ZERO);
        this.updateYAxis();
        this.repaint();
    }

    @Override
    public String toString() {
        return "Show the samples analysis as dot plots";
    }

    private void updateYAxis() {
        this.maxYField.setText(Long.toString(this.graph.getGraphMax()));
        this.minYField.setText(ZERO);
    }

    private void init() {
        this.setLayout(new BorderLayout());
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        this.setBorder(margin);
        JPanel graphPanel = new JPanel(new BorderLayout());
        graphPanel.add((Component)this.createYAxis(), "West");
        graphPanel.add((Component)this.createChoosePanel(), "North");
        graphPanel.add(this.createGraphPanel(), "Center");
        graphPanel.add((Component)this.createGraphInfoPanel(), "South");
        this.add((Component)this.makeTitlePanel(), "North");
        this.add((Component)graphPanel, "Center");
        new Timer(this.REFRESH_PERIOD, e -> this.collectSamplesFromQueue()).start();
    }

    private JPanel createYAxis() {
        JPanel graphYAxisPanel = new JPanel();
        graphYAxisPanel.setLayout(new BorderLayout());
        this.maxYField = this.createYAxisField(5);
        this.minYField = this.createYAxisField(3);
        graphYAxisPanel.add((Component)this.createYAxisPanel("graph_results_ms", this.maxYField), "North");
        graphYAxisPanel.add((Component)this.createYAxisPanel("graph_results_ms", this.minYField), "South");
        return graphYAxisPanel;
    }

    private JTextField createYAxisField(int length) {
        JTextField field = new JTextField(length);
        field.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        field.setEditable(false);
        field.setForeground(Color.black);
        field.setBackground(this.getBackground());
        field.setHorizontalAlignment(4);
        return field;
    }

    private JPanel createYAxisPanel(String labelResourceName, JTextField field) {
        JPanel panel = new JPanel(new FlowLayout());
        JLabel label = new JLabel(JMeterUtils.getResString(labelResourceName));
        panel.add(field);
        panel.add(label);
        return panel;
    }

    private JPanel createChoosePanel() {
        JPanel chooseGraphsPanel = new JPanel();
        chooseGraphsPanel.setLayout(new FlowLayout());
        JLabel selectGraphsLabel = new JLabel(JMeterUtils.getResString("graph_choose_graphs"));
        this.data = this.createChooseCheckBox("graph_results_data", Color.black);
        this.average = this.createChooseCheckBox("graph_results_average", Color.blue);
        this.deviation = this.createChooseCheckBox("graph_results_deviation", Color.red);
        this.throughput = this.createChooseCheckBox("graph_results_throughput", JMeterColor.DARK_GREEN);
        this.median = this.createChooseCheckBox("graph_results_median", JMeterColor.PURPLE);
        chooseGraphsPanel.add(selectGraphsLabel);
        chooseGraphsPanel.add(this.data);
        chooseGraphsPanel.add(this.average);
        chooseGraphsPanel.add(this.median);
        chooseGraphsPanel.add(this.deviation);
        chooseGraphsPanel.add(this.throughput);
        return chooseGraphsPanel;
    }

    private JCheckBox createChooseCheckBox(String labelResourceName, Color color) {
        JCheckBox checkBox = new JCheckBox(JMeterUtils.getResString(labelResourceName));
        checkBox.setSelected(true);
        checkBox.addItemListener(this);
        checkBox.setForeground(color);
        return checkBox;
    }

    private Component createGraphPanel() {
        JScrollPane graphScrollPanel = this.makeScrollPane(this.graph, 21, 30);
        graphScrollPanel.setViewportBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        graphScrollPanel.setPreferredSize(graphScrollPanel.getMinimumSize());
        return graphScrollPanel;
    }

    private Box createGraphInfoPanel() {
        Box graphInfoPanel = Box.createHorizontalBox();
        this.noSamplesField = this.createInfoField(Color.black, 6);
        this.dataField = this.createInfoField(Color.black, 5);
        this.averageField = this.createInfoField(Color.blue, 5);
        this.deviationField = this.createInfoField(Color.red, 5);
        this.throughputField = this.createInfoField(JMeterColor.DARK_GREEN, 15);
        this.medianField = this.createInfoField(JMeterColor.PURPLE, 5);
        graphInfoPanel.add(this.createInfoColumn(this.createInfoLabel("graph_results_no_samples", this.noSamplesField), this.noSamplesField, this.createInfoLabel("graph_results_deviation", this.deviationField), this.deviationField));
        graphInfoPanel.add(Box.createHorizontalGlue());
        graphInfoPanel.add(this.createInfoColumn(this.createInfoLabel("graph_results_latest_sample", this.dataField), this.dataField, this.createInfoLabel("graph_results_throughput", this.throughputField), this.throughputField));
        graphInfoPanel.add(Box.createHorizontalGlue());
        graphInfoPanel.add(this.createInfoColumn(this.createInfoLabel("graph_results_average", this.averageField), this.averageField, this.createInfoLabel("graph_results_median", this.medianField), this.medianField));
        graphInfoPanel.add(Box.createHorizontalGlue());
        return graphInfoPanel;
    }

    private JTextField createInfoField(Color color, int length) {
        JTextField field = new JTextField(length);
        field.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        field.setEditable(false);
        field.setForeground(color);
        field.setBackground(this.getBackground());
        field.setMaximumSize(new Dimension(field.getMaximumSize().width, field.getPreferredSize().height));
        return field;
    }

    private JLabel createInfoLabel(String labelResourceName, JTextField field) {
        JLabel label = new JLabel(JMeterUtils.getResString(labelResourceName));
        label.setForeground(field.getForeground());
        label.setLabelFor(field);
        return label;
    }

    private Box createInfoColumn(JLabel label1, JTextField field1, JLabel label2, JTextField field2) {
        Box row = Box.createHorizontalBox();
        Box col = Box.createVerticalBox();
        col.add(label1 != null ? label1 : Box.createVerticalGlue());
        col.add(label2 != null ? label2 : Box.createVerticalGlue());
        row.add(col);
        row.add(Box.createHorizontalStrut(5));
        col = Box.createVerticalBox();
        col.add(field1 != null ? field1 : Box.createVerticalGlue());
        col.add(field2 != null ? field2 : Box.createVerticalGlue());
        row.add(col);
        row.add(Box.createHorizontalStrut(5));
        return row;
    }
}

