/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.function.Consumer;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.XPathUtil;
import org.apache.jmeter.visualizers.ResultRenderer;
import org.apache.jmeter.visualizers.SamplerResultTab;
import org.apache.jmeter.visualizers.XMLDefaultMutableTreeNode;
import org.apache.jorphan.util.JOrphanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.tidy.Tidy;
import org.xml.sax.SAXException;

public class RenderAsXML
extends SamplerResultTab
implements ResultRenderer {
    private static final Logger log = LoggerFactory.getLogger(RenderAsXML.class);
    private static final byte[] XML_PFX = new byte[]{60, 63, 120, 109, 108, 32};

    public RenderAsXML() {
        this.activateSearchExtension = false;
    }

    @Override
    public void renderResult(SampleResult sampleResult) {
        this.showRenderXMLResponse(sampleResult);
    }

    private void showRenderXMLResponse(SampleResult res) {
        this.results.setContentType("text/xml");
        this.results.setCaretPosition(0);
        byte[] source = res.getResponseData();
        ByteArrayInputStream baIS = new ByteArrayInputStream(source);
        for (int i = 0; i < source.length - XML_PFX.length; ++i) {
            if (!JOrphanUtils.startsWith(source, XML_PFX, i)) continue;
            baIS.skip(i);
            break;
        }
        StringWriter sw = new StringWriter();
        Tidy tidy = XPathUtil.makeTidyParser(true, true, true, sw);
        Document document = tidy.parseDOM((InputStream)baIS, null);
        document.normalize();
        if (tidy.getParseErrors() > 0) {
            RenderAsXML.showErrorMessageDialog(sw.toString(), "Tidy: " + tidy.getParseErrors() + " errors, " + tidy.getParseWarnings() + " warnings", 2);
        }
        DOMTreePanel domTreePanel = new DOMTreePanel(document);
        new ExpandPopupMenu().add(domTreePanel);
        this.resultsScrollPane.setViewportView(domTreePanel);
    }

    @Override
    public void clearData() {
        super.clearData();
        this.resultsScrollPane.setViewportView(null);
    }

    private static void showErrorMessageDialog(String message, String title, int messageType) {
        JOptionPane.showMessageDialog(null, message, title, messageType);
    }

    @Override
    public String toString() {
        return JMeterUtils.getResString("view_results_render_xml");
    }

    private static class DOMTreePanel
    extends JPanel
    implements MouseListener {
        private static final long serialVersionUID = 6871690021183779153L;
        private JTree domJTree;
        private ExpandPopupMenu popupMenu;

        public DOMTreePanel(Document document) {
            super(new GridLayout(1, 0));
            try {
                Node firstElement = this.getFirstElement(document);
                XMLDefaultMutableTreeNode top = new XMLDefaultMutableTreeNode(firstElement);
                this.domJTree = new JTree(top);
                this.domJTree.getSelectionModel().setSelectionMode(1);
                this.domJTree.setShowsRootHandles(true);
                this.domJTree.addMouseListener(this);
                this.popupMenu = new ExpandPopupMenu();
                this.popupMenu.setTree(this.domJTree);
                JScrollPane domJScrollPane = new JScrollPane(this.domJTree);
                this.domJTree.setAutoscrolls(true);
                this.add(domJScrollPane);
                ToolTipManager.sharedInstance().registerComponent(this.domJTree);
                this.domJTree.setCellRenderer(new DomTreeRenderer());
            }
            catch (SAXException e) {
                log.warn("Error trying to parse document", e);
            }
        }

        private Node getFirstElement(Node parent) {
            NodeList childNodes = parent.getChildNodes();
            Node toReturn = parent;
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode;
                toReturn = childNode = childNodes.item(i);
                if (childNode.getNodeType() == 1) break;
            }
            return toReturn;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                int x = e.getX();
                int y = e.getY();
                JTree tree = (JTree)e.getSource();
                int rowIndex = tree.getClosestRowForLocation(x, y);
                if (rowIndex > -1) {
                    tree.setSelectionRow(rowIndex);
                    this.popupMenu.show(tree, x, y);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        private static class DomTreeRenderer
        extends DefaultTreeCellRenderer {
            private static final long serialVersionUID = 240210061375790195L;

            private DomTreeRenderer() {
            }

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean phasFocus) {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, phasFocus);
                DefaultMutableTreeNode valueTreeNode = (DefaultMutableTreeNode)value;
                this.setToolTipText(this.getHTML(valueTreeNode.toString(), "<br>", 100));
                return this;
            }

            private String getHTML(String str, String separator, int maxChar) {
                StringBuilder strBuf = new StringBuilder("<html><body bgcolor=\"yellow\"><b>");
                char[] chars = str.toCharArray();
                for (int i = 0; i < chars.length; ++i) {
                    if (i % maxChar == 0 && i != 0) {
                        strBuf.append(separator);
                    }
                    strBuf.append(this.encode(chars[i]));
                }
                strBuf.append("</b></body></html>");
                return strBuf.toString();
            }

            private String encode(char c) {
                String toReturn = String.valueOf(c);
                switch (c) {
                    case '<': {
                        toReturn = "&lt;";
                        break;
                    }
                    case '>': {
                        toReturn = "&gt;";
                        break;
                    }
                    case '\'': {
                        toReturn = "&apos;";
                        break;
                    }
                    case '\"': {
                        toReturn = "&quot;";
                        break;
                    }
                }
                return toReturn;
            }
        }
    }

    private static class ExpandPopupMenu
    extends JPopupMenu
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private JMenuItem expand = new JMenuItem(JMeterUtils.getResString("menu_expand_all"));
        private JMenuItem collapse;
        private JTree tree;

        ExpandPopupMenu() {
            this.expand.addActionListener(this);
            this.add(this.expand);
            this.collapse = new JMenuItem(JMeterUtils.getResString("menu_collapse_all"));
            this.collapse.addActionListener(this);
            this.add(this.collapse);
        }

        void setTree(JTree tree) {
            this.tree = tree;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.expand) {
                this.expandAll(this.tree.getSelectionPath());
            }
            if (e.getSource() == this.collapse) {
                this.collapseAll(this.tree.getSelectionPath());
            }
        }

        private void collapseAll(TreePath parent) {
            this.applyToChildren(parent, this::collapseAll);
            this.tree.collapsePath(parent);
        }

        private void expandAll(TreePath parent) {
            this.applyToChildren(parent, this::expandAll);
            this.tree.expandPath(parent);
        }

        private void applyToChildren(TreePath parent, Consumer<TreePath> method) {
            TreeNode node = (TreeNode)parent.getLastPathComponent();
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                method.accept(path);
            }
        }
    }
}

