/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javafx.application.Platform;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.ResultRenderer;
import org.apache.jmeter.visualizers.SamplerResultTab;
import org.apache.jmeter.visualizers.ViewResultsFullVisualizer;

public class RenderInBrowser
extends SamplerResultTab
implements ResultRenderer {
    private JFXPanel jfxPanel;
    private WebEngine engine;
    private final JLabel lblStatus = new JLabel();
    private final JProgressBar progressBar = new JProgressBar();
    private JPanel browserPanel;

    @Override
    public void renderResult(SampleResult sampleResult) {
        String response = ViewResultsFullVisualizer.getResponseAsString(sampleResult);
        this.showRenderedResponse(response, sampleResult);
    }

    protected void showRenderedResponse(String response, SampleResult res) {
        if (response == null) {
            this.results.setText("");
            return;
        }
        int htmlIndex = response.indexOf("<HTML");
        if (htmlIndex < 0) {
            htmlIndex = response.indexOf("<html");
        }
        if (htmlIndex < 0) {
            htmlIndex = 0;
        }
        String html = response.substring(htmlIndex);
        if (this.browserPanel == null) {
            this.browserPanel = this.initComponents(html);
        }
        this.browserPanel.setVisible(true);
        this.resultsScrollPane.setViewportView(this.browserPanel);
        Platform.runLater(() -> this.engine.loadContent(html));
    }

    private JPanel initComponents(String htmlContent) {
        this.jfxPanel = new JFXPanel();
        this.createScene(htmlContent);
        this.progressBar.setPreferredSize(new Dimension(150, 18));
        this.progressBar.setStringPainted(true);
        JPanel statusBar = new JPanel(new BorderLayout(5, 0));
        statusBar.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        statusBar.add((Component)this.lblStatus, "Center");
        statusBar.add((Component)this.progressBar, "West");
        JPanel panel = new JPanel(new BorderLayout());
        panel.setPreferredSize(new Dimension(1024, 600));
        panel.add((Component)statusBar, "North");
        panel.add((Component)this.jfxPanel, "Center");
        return panel;
    }

    private void createScene(String htmlContent) {
        Platform.setImplicitExit((boolean)false);
        Platform.runLater(() -> {
            WebView view = new WebView();
            this.engine = view.getEngine();
            this.engine.setOnStatusChanged(event -> SwingUtilities.invokeLater(() -> this.lblStatus.setText((String)event.getData())));
            this.engine.getLoadWorker().workDoneProperty().addListener((observableValue, oldValue, newValue) -> SwingUtilities.invokeLater(() -> this.progressBar.setValue(newValue.intValue())));
            this.engine.getLoadWorker().exceptionProperty().addListener((o, old, value) -> {
                if (this.engine.getLoadWorker().getState() == Worker.State.FAILED) {
                    SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this.resultsScrollPane, value != null ? this.engine.getLocation() + "\n" + value.getMessage() : this.engine.getLocation() + "\nUnexpected error.", "Loading error...", 0));
                }
            });
            this.jfxPanel.setScene(new Scene((Parent)view));
        });
    }

    @Override
    public String toString() {
        return JMeterUtils.getResString("view_results_render_browser");
    }

    @Override
    public void clearData() {
        super.clearData();
        if (this.browserPanel == null) {
            this.browserPanel = this.initComponents("");
        }
        Platform.runLater(() -> this.engine.loadContent(""));
    }
}

