/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.apache.jmeter.gui.util.JSyntaxSearchToolBar;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.gui.util.JTextScrollPane;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.RequestView;
import org.apache.jorphan.gui.GuiUtils;

public class RequestViewRaw
implements RequestView {
    static final String KEY_LABEL = "view_results_table_request_tab_raw";
    private JSyntaxTextArea headerData;
    private JSyntaxTextArea sampleDataField;
    private JPanel paneRaw;

    @Override
    public void init() {
        this.paneRaw = new JPanel(new BorderLayout(0, 5));
        this.sampleDataField = JSyntaxTextArea.getInstance(20, 80, true);
        this.sampleDataField.setEditable(false);
        this.sampleDataField.setLineWrap(true);
        this.sampleDataField.setWrapStyleWord(true);
        JPanel requestAndSearchPanel = new JPanel(new BorderLayout());
        requestAndSearchPanel.add((Component)new JSyntaxSearchToolBar(this.sampleDataField).getToolBar(), "North");
        requestAndSearchPanel.add((Component)((Object)JTextScrollPane.getInstance(this.sampleDataField)), "Center");
        this.headerData = JSyntaxTextArea.getInstance(20, 80, true);
        this.headerData.setEditable(false);
        this.headerData.setLineWrap(true);
        this.headerData.setWrapStyleWord(true);
        JPanel headerAndSearchPanel = new JPanel(new BorderLayout());
        headerAndSearchPanel.add((Component)new JSyntaxSearchToolBar(this.headerData).getToolBar(), "North");
        headerAndSearchPanel.add((Component)((Object)JTextScrollPane.getInstance(this.headerData)), "Center");
        JTabbedPane tabbedPane = new JTabbedPane(1);
        tabbedPane.addTab(JMeterUtils.getResString("view_results_request_body"), new JScrollPane(requestAndSearchPanel));
        tabbedPane.addTab(JMeterUtils.getResString("view_results_request_headers"), new JScrollPane(headerAndSearchPanel));
        this.paneRaw.add(GuiUtils.makeScrollPane(tabbedPane));
    }

    @Override
    public void clearData() {
        this.sampleDataField.setInitialText("");
        this.headerData.setInitialText("");
    }

    @Override
    public void setSamplerResult(Object objectResult) {
        if (objectResult instanceof SampleResult) {
            String data;
            SampleResult sampleResult = (SampleResult)objectResult;
            String rh = sampleResult.getRequestHeaders();
            if (rh != null && !rh.isEmpty()) {
                this.headerData.setInitialText(rh);
                this.sampleDataField.setCaretPosition(0);
            }
            if ((data = sampleResult.getSamplerData()) != null && !data.isEmpty()) {
                this.sampleDataField.setText(data);
                this.sampleDataField.setCaretPosition(0);
            } else {
                this.sampleDataField.setText(JMeterUtils.getResString("view_results_table_request_raw_nodata"));
            }
        }
    }

    @Override
    public JPanel getPanel() {
        return this.paneRaw;
    }

    @Override
    public String getLabel() {
        return JMeterUtils.getResString(KEY_LABEL);
    }
}

