/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.gui.Searchable;
import org.apache.jmeter.gui.action.KeyStrokes;
import org.apache.jmeter.gui.action.RawTextSearcher;
import org.apache.jmeter.gui.action.RegexpSearcher;
import org.apache.jmeter.gui.action.Searcher;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.SearchableTreeNode;
import org.apache.jmeter.visualizers.utils.Colors;
import org.apache.jorphan.gui.JFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchTreePanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(SearchTreePanel.class);
    private static final String SEARCH_TEXT_COMMAND = "search_text";
    private JButton searchButton;
    private JTextField searchTF;
    private JCheckBox isRegexpCB;
    private JCheckBox isCaseSensitiveCB;
    private JButton resetButton;
    private DefaultMutableTreeNode defaultMutableTreeNode;

    public SearchTreePanel(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.init();
        this.defaultMutableTreeNode = defaultMutableTreeNode;
    }

    @Deprecated
    public SearchTreePanel() {
    }

    private void init() {
        this.setLayout(new BorderLayout(10, 10));
        this.searchTF = new JTextField(20);
        JFactory.small(this.searchTF);
        InputMap im = this.searchTF.getInputMap(2);
        im.put(KeyStrokes.ENTER, SEARCH_TEXT_COMMAND);
        ActionMap am = this.searchTF.getActionMap();
        am.put(SEARCH_TEXT_COMMAND, new EnterAction());
        this.isRegexpCB = new JCheckBox(JMeterUtils.getResString("search_text_chkbox_regexp"), false);
        this.isCaseSensitiveCB = new JCheckBox(JMeterUtils.getResString("search_text_chkbox_case"), false);
        JFactory.small(this.isRegexpCB);
        JFactory.small(this.isCaseSensitiveCB);
        this.searchButton = new JButton(JMeterUtils.getResString("search"));
        this.searchButton.addActionListener(this);
        this.resetButton = new JButton(JMeterUtils.getResString("reset"));
        this.resetButton.addActionListener(this);
        JPanel searchPanel = new JPanel(new FlowLayout(0));
        JLabel searchLabel = new JLabel(JMeterUtils.getResString("search_text_field"));
        JFactory.small(searchLabel);
        searchPanel.add(searchLabel);
        searchPanel.add(this.searchTF);
        searchPanel.add(this.isCaseSensitiveCB);
        searchPanel.add(this.isRegexpCB);
        searchPanel.add(this.searchButton);
        searchPanel.add(this.resetButton);
        this.add(searchPanel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.searchButton) {
            this.doSearch();
        } else if (e.getSource() == this.resetButton) {
            this.doResetSearch((SearchableTreeNode)this.defaultMutableTreeNode);
        }
    }

    private void doResetSearch(SearchableTreeNode searchableTreeNode) {
        searchableTreeNode.reset();
        searchableTreeNode.updateState();
        for (int i = 0; i < searchableTreeNode.getChildCount(); ++i) {
            this.doResetSearch((SearchableTreeNode)searchableTreeNode.getChildAt(i));
        }
    }

    private boolean doSearch() {
        String wordToSearch = this.searchTF.getText();
        if (StringUtils.isEmpty(wordToSearch)) {
            return false;
        }
        Searcher searcher = this.isRegexpCB.isSelected() ? new RegexpSearcher(this.isCaseSensitiveCB.isSelected(), this.searchTF.getText()) : new RawTextSearcher(this.isCaseSensitiveCB.isSelected(), this.searchTF.getText());
        return this.searchInNode(searcher, (SearchableTreeNode)this.defaultMutableTreeNode);
    }

    private boolean searchInNode(Searcher searcher, SearchableTreeNode node) {
        node.reset();
        Object userObject = node.getUserObject();
        try {
            if (!(userObject instanceof Searchable)) {
                return false;
            }
            Searchable searchable = (Searchable)userObject;
            if (searcher.search(searchable.getSearchableTokens())) {
                node.setNodeHasMatched(true);
            }
            boolean foundInChildren = false;
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.searchInNode(searcher, (SearchableTreeNode)node.getChildAt(i));
                foundInChildren = this.searchInNode(searcher, (SearchableTreeNode)node.getChildAt(i)) || foundInChildren;
            }
            if (!node.isNodeHasMatched()) {
                node.setChildrenNodesHaveMatched(foundInChildren);
            }
            node.updateState();
            return node.isNodeHasMatched() || node.isChildrenNodesHaveMatched();
        }
        catch (Exception e) {
            log.error("Error extracting data from tree node using searcher:{}", (Object)searcher, (Object)e);
            return false;
        }
    }

    private class EnterAction
    extends AbstractAction {
        private static final long serialVersionUID = 2L;

        private EnterAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            boolean found = SearchTreePanel.this.doSearch();
            if (found) {
                SearchTreePanel.this.searchTF.setBackground(Color.WHITE);
                SearchTreePanel.this.searchTF.setForeground(Color.BLACK);
            } else {
                SearchTreePanel.this.searchTF.setBackground(Colors.LIGHT_RED);
                SearchTreePanel.this.searchTF.setForeground(Color.WHITE);
            }
        }
    }
}

