/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;

public class TreeNodeRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 240L;
    private static final String ICON_SIZE = JMeterUtils.getPropDefault("jmeter.tree.icons.size", "19x19");
    private static final ImageIcon imageSuccess = JMeterUtils.getImage(JMeterUtils.getPropDefault("viewResultsTree.success", "vrt/" + ICON_SIZE + "/security-high-2.png"));
    private static final ImageIcon imageFailure = JMeterUtils.getImage(JMeterUtils.getPropDefault("viewResultsTree.failure", "vrt/" + ICON_SIZE + "/security-low-2.png"));

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, focus);
        Object obj = ((DefaultMutableTreeNode)value).getUserObject();
        if (obj instanceof SampleResult) {
            if (!((SampleResult)obj).isSuccessful()) {
                this.setForeground(UIManager.getColor("[jmeter]Label.errorForeground"));
                this.setIcon(imageFailure);
            } else {
                this.setIcon(imageSuccess);
            }
        }
        return this;
    }
}

