/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers.backend.graphite;

import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.commons.pool2.BaseKeyedPooledObjectFactory;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.jmeter.visualizers.backend.graphite.SocketConnectionInfos;
import org.apache.jmeter.visualizers.backend.graphite.SocketOutputStream;
import org.apache.jorphan.util.JOrphanUtils;

public class SocketOutputStreamPoolFactory
extends BaseKeyedPooledObjectFactory<SocketConnectionInfos, SocketOutputStream>
implements KeyedPooledObjectFactory<SocketConnectionInfos, SocketOutputStream> {
    private final int socketTimeoutInMillis;
    private final int socketConnectTimeoutInMillis;

    public SocketOutputStreamPoolFactory(int socketConnectTimeoutInMillis, int socketTimeoutInMillis) {
        this.socketConnectTimeoutInMillis = socketConnectTimeoutInMillis;
        this.socketTimeoutInMillis = socketTimeoutInMillis;
    }

    @Override
    public PooledObject<SocketOutputStream> makeObject(SocketConnectionInfos connectionInfos) throws Exception {
        return this.wrap(this.create(connectionInfos));
    }

    @Override
    public void destroyObject(SocketConnectionInfos socketConnectionInfos, PooledObject<SocketOutputStream> socketOutputStream) throws Exception {
        super.destroyObject(socketConnectionInfos, socketOutputStream);
        SocketOutputStream outputStream = socketOutputStream.getObject();
        JOrphanUtils.closeQuietly(outputStream);
        JOrphanUtils.closeQuietly(outputStream.getSocket());
    }

    @Override
    public boolean validateObject(SocketConnectionInfos hostAndPort, PooledObject<SocketOutputStream> socketOutputStream) {
        Socket socket = socketOutputStream.getObject().getSocket();
        return socket.isConnected() && socket.isBound() && !socket.isClosed() && !socket.isInputShutdown() && !socket.isOutputShutdown();
    }

    @Override
    public SocketOutputStream create(SocketConnectionInfos connectionInfos) throws Exception {
        Socket socket = new Socket();
        socket.setKeepAlive(true);
        socket.setSoTimeout(this.socketTimeoutInMillis);
        socket.connect(new InetSocketAddress(connectionInfos.getHost(), connectionInfos.getPort()), this.socketConnectTimeoutInMillis);
        return new SocketOutputStream(socket);
    }

    @Override
    public PooledObject<SocketOutputStream> wrap(SocketOutputStream outputStream) {
        return new DefaultPooledObject<SocketOutputStream>(outputStream);
    }
}

