/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers.backend.influxdb;

import java.io.Closeable;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.util.EntityUtils;
import org.apache.jmeter.report.utils.MetricUtils;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.backend.influxdb.AbstractInfluxdbMetricsSender;
import org.apache.jmeter.visualizers.backend.influxdb.InfluxdbMetricsSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpMetricsSender
extends AbstractInfluxdbMetricsSender {
    private static final Logger log = LoggerFactory.getLogger(HttpMetricsSender.class);
    private static final String AUTHORIZATION_HEADER_NAME = "Authorization";
    private static final String AUTHORIZATION_HEADER_VALUE = "Token ";
    private final Object lock = new Object();
    private List<InfluxdbMetricsSender.MetricTuple> metrics = new ArrayList<InfluxdbMetricsSender.MetricTuple>();
    private HttpPost httpRequest;
    private CloseableHttpAsyncClient httpClient;
    private URL url;
    private String token;
    private Future<HttpResponse> lastRequest;

    HttpMetricsSender() {
    }

    @Override
    public void setup(String influxdbUrl, String influxDBToken) throws Exception {
        IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setIoThreadCount(1).setConnectTimeout(JMeterUtils.getPropDefault("backend_influxdb.connection_timeout", 1000)).setSoTimeout(JMeterUtils.getPropDefault("backend_influxdb.socket_timeout", 3000)).build();
        DefaultConnectingIOReactor ioReactor = new DefaultConnectingIOReactor(ioReactorConfig);
        PoolingNHttpClientConnectionManager connManager = new PoolingNHttpClientConnectionManager(ioReactor);
        this.httpClient = HttpAsyncClientBuilder.create().setConnectionManager(connManager).setMaxConnPerRoute(2).setMaxConnTotal(2).setUserAgent("ApacheJMeter" + JMeterUtils.getJMeterVersion()).disableCookieManagement().disableConnectionState().build();
        this.url = new URL(influxdbUrl);
        this.token = influxDBToken;
        this.httpRequest = this.createRequest(this.url, this.token);
        this.httpClient.start();
    }

    private HttpPost createRequest(URL url, String token) throws URISyntaxException {
        RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(JMeterUtils.getPropDefault("backend_influxdb.connection_timeout", 1000)).setSocketTimeout(JMeterUtils.getPropDefault("backend_influxdb.socket_timeout", 3000)).setConnectionRequestTimeout(JMeterUtils.getPropDefault("backend_influxdb.connection_request_timeout", 100)).build();
        HttpPost currentHttpRequest = new HttpPost(url.toURI());
        currentHttpRequest.setConfig(defaultRequestConfig);
        if (StringUtils.isNotBlank(token)) {
            currentHttpRequest.setHeader(AUTHORIZATION_HEADER_NAME, AUTHORIZATION_HEADER_VALUE + token);
        }
        log.debug("Created InfluxDBMetricsSender with url: {}", (Object)url);
        return currentHttpRequest;
    }

    @Override
    public void addMetric(String measurement, String tag, String field) {
        this.addMetric(measurement, tag, field, System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMetric(String measurement, String tag, String field, long timestamp) {
        Object object = this.lock;
        synchronized (object) {
            this.metrics.add(new InfluxdbMetricsSender.MetricTuple(measurement, tag, field, timestamp));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeAndSendMetrics() {
        List<InfluxdbMetricsSender.MetricTuple> copyMetrics;
        Object object = this.lock;
        synchronized (object) {
            if (this.metrics.isEmpty()) {
                return;
            }
            copyMetrics = this.metrics;
            this.metrics = new ArrayList<InfluxdbMetricsSender.MetricTuple>(copyMetrics.size());
        }
        this.writeAndSendMetrics(copyMetrics);
    }

    private void writeAndSendMetrics(final List<InfluxdbMetricsSender.MetricTuple> copyMetrics) {
        try {
            if (this.httpRequest == null) {
                this.httpRequest = this.createRequest(this.url, this.token);
            }
            StringBuilder sb = new StringBuilder(copyMetrics.size() * 35);
            for (InfluxdbMetricsSender.MetricTuple metric : copyMetrics) {
                sb.append(metric.measurement).append(metric.tag).append(" ").append(metric.field).append(" ").append(metric.timestamp).append("000000").append("\n");
            }
            String data = sb.toString();
            log.debug("Sending to influxdb:{}", (Object)data);
            this.httpRequest.setEntity(new StringEntity(data, StandardCharsets.UTF_8));
            this.lastRequest = this.httpClient.execute(this.httpRequest, new FutureCallback<HttpResponse>(){

                @Override
                public void completed(HttpResponse response) {
                    int code = response.getStatusLine().getStatusCode();
                    if (MetricUtils.isSuccessCode(code)) {
                        if (log.isDebugEnabled()) {
                            log.debug("Success, number of metrics written: {}", (Object)copyMetrics.size());
                        }
                    } else {
                        log.error("Error writing metrics to influxDB Url: {}, responseCode: {}, responseBody: {}", HttpMetricsSender.this.url, code, HttpMetricsSender.getBody(response));
                    }
                }

                @Override
                public void failed(Exception ex) {
                    log.error("failed to send data to influxDB server.", ex);
                }

                @Override
                public void cancelled() {
                    log.warn("Request to influxDB server was cancelled");
                }
            });
        }
        catch (URISyntaxException ex) {
            log.error(ex.getMessage(), ex);
        }
    }

    private static String getBody(HttpResponse response) {
        String body = "";
        try {
            if (response != null && response.getEntity() != null) {
                body = EntityUtils.toString(response.getEntity());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return body;
    }

    @Override
    public void destroy() {
        log.info("Destroying ");
        try {
            this.lastRequest.get(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.error("Error waiting for last request to be send to InfluxDB", e);
        }
        if (this.httpRequest != null) {
            this.httpRequest.abort();
        }
        IOUtils.closeQuietly((Closeable)this.httpClient, null);
    }
}

