/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers.backend.influxdb;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.visualizers.backend.BackendListenerClient;
import org.apache.jmeter.visualizers.backend.BackendListenerContext;
import org.apache.jmeter.visualizers.backend.influxdb.AbstractInfluxdbMetricsSender;
import org.apache.jmeter.visualizers.backend.influxdb.HttpMetricsSender;
import org.apache.jmeter.visualizers.backend.influxdb.InfluxdbMetricsSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxDBRawBackendListenerClient
implements BackendListenerClient {
    private static final Logger log = LoggerFactory.getLogger(InfluxDBRawBackendListenerClient.class);
    private static final Object LOCK = new Object();
    private static final String TAG_OK = "ok";
    private static final String TAG_KO = "ko";
    private static final String DEFAULT_MEASUREMENT = "jmeter";
    private static final Map<String, String> DEFAULT_ARGS = new LinkedHashMap<String, String>();
    private InfluxdbMetricsSender influxDBMetricsManager;
    private String measurement;

    public InfluxDBRawBackendListenerClient() {
    }

    public InfluxDBRawBackendListenerClient(InfluxdbMetricsSender sender) {
        this.influxDBMetricsManager = sender;
    }

    @Override
    public void setupTest(BackendListenerContext context) throws Exception {
        this.initInfluxDBMetricsManager(context);
        this.measurement = context.getParameter("measurement", DEFAULT_MEASUREMENT);
    }

    private void initInfluxDBMetricsManager(BackendListenerContext context) throws Exception {
        this.influxDBMetricsManager = Class.forName(context.getParameter("influxdbMetricsSender")).asSubclass(InfluxdbMetricsSender.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.influxDBMetricsManager.setup(context.getParameter("influxdbUrl"), context.getParameter("influxdbToken"));
    }

    @Override
    public void teardownTest(BackendListenerContext context) {
        this.influxDBMetricsManager.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleSampleResults(List<SampleResult> sampleResults, BackendListenerContext context) {
        log.debug("Handling {} sample results", (Object)sampleResults.size());
        Object object = LOCK;
        synchronized (object) {
            for (SampleResult sampleResult : sampleResults) {
                this.addMetricFromSampleResult(sampleResult);
            }
            this.influxDBMetricsManager.writeAndSendMetrics();
        }
    }

    private void addMetricFromSampleResult(SampleResult sampleResult) {
        String tags = "," + this.createTags(sampleResult);
        String fields = this.createFields(sampleResult);
        long timestamp = sampleResult.getTimeStamp();
        this.influxDBMetricsManager.addMetric(this.measurement, tags, fields, timestamp);
    }

    private String createTags(SampleResult sampleResult) {
        boolean isError = sampleResult.getErrorCount() != 0;
        String status = isError ? TAG_KO : TAG_OK;
        String label = StringUtils.strip(sampleResult.getSampleLabel(), "\" ");
        String transaction = AbstractInfluxdbMetricsSender.tagToStringValue(label);
        return "status=" + status + ",transaction=" + transaction;
    }

    private String createFields(SampleResult sampleResult) {
        long duration = sampleResult.getTime();
        long latency = sampleResult.getLatency();
        long connectTime = sampleResult.getConnectTime();
        return "duration=" + duration + ",ttfb=" + latency + ",connectTime=" + connectTime;
    }

    @Override
    public Arguments getDefaultParameters() {
        Arguments arguments = new Arguments();
        DEFAULT_ARGS.forEach(arguments::addArgument);
        return arguments;
    }

    static {
        DEFAULT_ARGS.put("influxdbMetricsSender", HttpMetricsSender.class.getName());
        DEFAULT_ARGS.put("influxdbUrl", "http://host_to_change:8086/write?db=jmeter");
        DEFAULT_ARGS.put("influxdbToken", "");
        DEFAULT_ARGS.put("measurement", DEFAULT_MEASUREMENT);
    }
}

