/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers.utils;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.JOptionPane;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Colors {
    private static final Logger log = LoggerFactory.getLogger(Colors.class);
    private static final String ENTRY_SEP = ",";
    private static final String ORDER_PROP_NAME = "order";
    protected static final String DEFAULT_COLORS_PROPERTY_FILE = "org/apache/jmeter/visualizers/utils/colors.properties";
    protected static final String USER_DEFINED_COLORS_PROPERTY_FILE = "jmeter.colors";
    private static final String COLORS_ORDER = "jmeter.order";
    public static final Color LIGHT_RED = new Color(255, 128, 128);

    public static List<Color> getColors() {
        Properties defaultProps = JMeterUtils.loadProperties(DEFAULT_COLORS_PROPERTY_FILE);
        if (defaultProps == null) {
            JOptionPane.showMessageDialog(null, JMeterUtils.getResString("toolbar_icon_set_not_found"), JMeterUtils.getResString("toolbar_icon_set_not_found"), 2);
            return null;
        }
        String userProp = JMeterUtils.getProperty(USER_DEFINED_COLORS_PROPERTY_FILE);
        Properties p = userProp != null ? JMeterUtils.loadProperties(userProp, defaultProps) : defaultProps;
        String order = JMeterUtils.getPropDefault(COLORS_ORDER, p.getProperty(ORDER_PROP_NAME));
        if (order == null) {
            log.warn("Could not find order list");
            JOptionPane.showMessageDialog(null, JMeterUtils.getResString("toolbar_icon_set_not_found"), JMeterUtils.getResString("toolbar_icon_set_not_found"), 2);
            return null;
        }
        String[] oList = order.split(ENTRY_SEP);
        ArrayList<Color> listColors = new ArrayList<Color>();
        for (String key : oList) {
            String trimmed = key.trim();
            String property = p.getProperty(trimmed);
            try {
                String[] lcol = property.split(ENTRY_SEP);
                Color itb = new Color(Integer.parseInt(lcol[0]), Integer.parseInt(lcol[1]), Integer.parseInt(lcol[2]));
                listColors.add(itb);
            }
            catch (Exception e) {
                log.warn("Error in colors.properties, current property={}", (Object)property);
            }
        }
        return listColors;
    }
}

