/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.codegeneration;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.collections.HashTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.abstracta.jmeter.javadsl.JmeterDsl;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCallBuilder;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCallContext;
import us.abstracta.jmeter.javadsl.core.DslTestElement;
import us.abstracta.jmeter.javadsl.core.engines.JmeterEnvironment;
import us.abstracta.jmeter.javadsl.core.testelements.BaseTestElement;

public class DslCodeGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(DslCodeGenerator.class);
    private final List<MethodCallBuilder> builders = new ArrayList<MethodCallBuilder>();

    public DslCodeGenerator() {
        this.addBuildersFrom(JmeterDsl.class);
    }

    public String generateCodeFromJmx(File file) throws IOException {
        JmeterEnvironment env = new JmeterEnvironment();
        HashTree tree = env.loadTree(new File(file.getPath()));
        TestElement testPlanElem = (TestElement)tree.getArray()[0];
        return new MethodCallContext(testPlanElem, tree.getTree(testPlanElem), this).buildMethodCall().buildCode();
    }

    public void addBuildersFrom(Class<?> ... dslClasses) {
        this.builders.addAll(this.findCallBuilders(dslClasses));
    }

    private List<MethodCallBuilder> findCallBuilders(Class<?> ... dslClasses) {
        Map<Class<? extends DslTestElement>, List<Method>> builderMethods = this.findBuilderMethods(dslClasses);
        return builderMethods.entrySet().stream().map(e -> this.buildCallBuilder((Class)e.getKey(), (List)e.getValue())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Map<Class<? extends DslTestElement>, List<Method>> findBuilderMethods(Class<?> ... dslClasses) {
        return Arrays.stream(dslClasses).flatMap(c -> Arrays.stream(c.getDeclaredMethods()).filter(m -> Modifier.isPublic(m.getModifiers()) && Modifier.isStatic(m.getModifiers()) && BaseTestElement.class.isAssignableFrom(m.getReturnType()))).collect(Collectors.groupingBy(m -> m.getReturnType()));
    }

    private MethodCallBuilder buildCallBuilder(Class<? extends DslTestElement> testElementClass, List<Method> builderMethods) {
        String builderClass = testElementClass.getName() + "$CodeBuilder";
        try {
            return (MethodCallBuilder)Class.forName(builderClass).getConstructor(List.class).newInstance(builderMethods);
        }
        catch (ClassNotFoundException e) {
            LOG.debug("No code builder associated to {}", (Object)testElementClass);
            return null;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Problem instantiating builder for " + builderClass + ". Check builder constructor with a list of methods and registry as parameters.", e);
        }
    }

    protected List<MethodCallBuilder> getBuilders() {
        return this.builders;
    }

    protected <T extends MethodCallBuilder> T findBuilder(Class<T> builderClass) {
        return (T)((MethodCallBuilder)this.builders.stream().filter(builderClass::isInstance).map(builderClass::cast).findAny().orElse(null));
    }
}

