/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.codegeneration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.collections.HashTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.abstracta.jmeter.javadsl.codegeneration.DslCodeGenerator;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCall;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCallBuilder;

public class MethodCallContext {
    private static final Logger LOG = LoggerFactory.getLogger(MethodCallContext.class);
    private static final String UNSUPPORTED_USAGE_WARNING = "Using unsupported() as parent for children's conversions and ease manual code completion.";
    private final TestElement testElement;
    private final HashTree childrenThree;
    private final MethodCallContext parent;
    private final DslCodeGenerator codeGenerator;
    private final Map<Object, Object> entries = new HashMap<Object, Object>();
    private final List<MethodCallContextEndListener> endListeners = new ArrayList<MethodCallContextEndListener>();

    protected MethodCallContext(TestElement testElement, HashTree childrenThree, DslCodeGenerator codeGenerator) {
        this(testElement, childrenThree, null, codeGenerator);
    }

    protected MethodCallContext(TestElement testElement, HashTree childrenThree, MethodCallContext parent, DslCodeGenerator codeGenerator) {
        this.testElement = testElement;
        this.childrenThree = childrenThree;
        this.parent = parent;
        this.codeGenerator = codeGenerator;
    }

    public TestElement getTestElement() {
        return this.testElement;
    }

    public MethodCallContext getParent() {
        return this.parent;
    }

    public HashTree getChildrenTree() {
        return this.childrenThree;
    }

    public Object getEntry(Object key) {
        return this.entries.get(key);
    }

    public void setEntry(Object key, Object value) {
        this.entries.put(key, value);
    }

    public void addEndListener(MethodCallContextEndListener listener) {
        this.endListeners.add(listener);
    }

    public MethodCall buildMethodCall() {
        try {
            MethodCall ret = this.codeGenerator.getBuilders().stream().map(b -> b.buildMethodCall(this)).filter(Objects::nonNull).findAny().orElseGet(() -> {
                LOG.warn("No builder found for {}. Using unsupported() as parent for children's conversions and ease manual code completion.", (Object)this.testElement);
                return MethodCall.buildUnsupported();
            });
            this.addChildrenTo(ret);
            this.endListeners.forEach(l -> l.execute(this, ret));
            return ret;
        }
        catch (UnsupportedOperationException e) {
            LOG.warn("Could not build code for {}. Using unsupported() as parent for children's conversions and ease manual code completion.", (Object)this.testElement, (Object)e);
            return MethodCall.buildUnsupported();
        }
    }

    private void addChildrenTo(MethodCall call) {
        List<MethodCall> children = this.buildChildrenMethodCalls();
        if (children.isEmpty()) {
            return;
        }
        children.forEach(call::child);
    }

    private List<MethodCall> buildChildrenMethodCalls() {
        return this.childrenThree == null ? Collections.emptyList() : this.childrenThree.list().stream().map(c -> (TestElement)c).filter(TestElement::isEnabled).map(c -> new MethodCallContext((TestElement)c, this.childrenThree.getTree(c), this, this.codeGenerator).buildMethodCall()).filter(c -> !c.isEmptyCall()).collect(Collectors.toList());
    }

    public MethodCallContext removeChild(Class<? extends TestElement> testElementClass) {
        Optional<TestElement> child = this.childrenThree.list().stream().filter(testElementClass::isInstance).map(testElementClass::cast).findAny();
        child.ifPresent(this.childrenThree::remove);
        return child.map(c -> new MethodCallContext((TestElement)c, this.childrenThree.getTree(c), this, this.codeGenerator)).orElse(null);
    }

    public <T extends MethodCallBuilder> T findBuilder(Class<T> builderClass) {
        return this.codeGenerator.findBuilder(builderClass);
    }

    public static interface MethodCallContextEndListener {
        public void execute(MethodCallContext var1, MethodCall var2);
    }
}

