/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.engines;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.reporters.Summariser;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.Visualizer;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.ListedHashTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.abstracta.jmeter.javadsl.core.BuildTreeContext;
import us.abstracta.jmeter.javadsl.core.DslJmeterEngine;
import us.abstracta.jmeter.javadsl.core.DslTestPlan;
import us.abstracta.jmeter.javadsl.core.TestPlanStats;
import us.abstracta.jmeter.javadsl.core.engines.EmbeddedStatsSummary;
import us.abstracta.jmeter.javadsl.core.engines.JmeterEnvironment;
import us.abstracta.jmeter.javadsl.core.listeners.DslVisualizer;

public class EmbeddedJmeterEngine
implements DslJmeterEngine {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedJmeterEngine.class);
    private final Map<String, Object> props = new HashMap<String, Object>();

    public EmbeddedJmeterEngine prop(String name, Object value) {
        this.props.put(name, value);
        return this;
    }

    @Override
    public TestPlanStats run(DslTestPlan testPlan) throws IOException {
        return this.runInEnv(testPlan, new JmeterEnvironment());
    }

    protected TestPlanStats runInEnv(DslTestPlan testPlan, JmeterEnvironment env) {
        JMeterUtils.getJMeterProperties().putAll(this.props);
        ListedHashTree rootTree = new ListedHashTree();
        BuildTreeContext buildContext = new BuildTreeContext();
        HashTree testPlanTree = buildContext.buildTreeFor(testPlan, rootTree);
        env.updateSearchPath(testPlanTree);
        TestPlanStats stats = new TestPlanStats(EmbeddedStatsSummary::new);
        this.addStatsCollector(testPlanTree, stats);
        testPlanTree.add(new ResultCollector(new Summariser()));
        List<Future<Void>> closedVisualizers = Collections.emptyList();
        TestRunner testRunner = this.buildTestRunner(testPlanTree, rootTree);
        Map<DslVisualizer, Supplier<Component>> visualizers = buildContext.getVisualizers();
        if (!visualizers.isEmpty()) {
            env.initLocale();
            closedVisualizers = this.showVisualizers(visualizers, testRunner);
        }
        stats.setStart(Instant.now());
        testRunner.run();
        stats.setEnd(Instant.now());
        this.awaitAllClosedVisualizers(closedVisualizers);
        return stats;
    }

    protected void addStatsCollector(HashTree testPlanTree, final TestPlanStats stats) {
        ResultCollector collector = new ResultCollector();
        Visualizer statsVisualizer = new Visualizer(){

            @Override
            public void add(SampleResult r) {
                stats.addSampleResult(r);
            }

            @Override
            public boolean isStats() {
                return true;
            }
        };
        collector.setListener(statsVisualizer);
        testPlanTree.add(collector);
        testPlanTree.add(statsVisualizer);
    }

    protected TestRunner buildTestRunner(HashTree testPlanTree, HashTree rootTree) {
        final StandardJMeterEngine engine = new StandardJMeterEngine();
        engine.configure(rootTree);
        return new TestRunner(){

            @Override
            public void runTest() {
                engine.run();
            }

            @Override
            public void stop() {
                engine.stopTest();
            }
        };
    }

    private List<Future<Void>> showVisualizers(Map<DslVisualizer, Supplier<Component>> visualizers, TestRunner testRunner) {
        return visualizers.entrySet().stream().map(e -> {
            CompletableFuture closedVisualizer = new CompletableFuture();
            Component guiComponent = (Component)((Supplier)e.getValue()).get();
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.add(this.buildToolbar(testRunner), "North");
            panel.add(guiComponent, "Center");
            ((DslVisualizer)e.getKey()).showTestElementGui(panel, () -> closedVisualizer.complete(null));
            return closedVisualizer;
        }).collect(Collectors.toList());
    }

    private Component buildToolbar(TestRunner testRunner) {
        JToolBar toolbar = new JToolBar();
        toolbar.add(this.buildStopButton(testRunner));
        return toolbar;
    }

    private JButton buildStopButton(TestRunner testRunner) {
        URL iconResource = JMeterUtils.class.getClassLoader().getResource("org/apache/jmeter/images/toolbar/22x22/road-sign-us-stop.png");
        JButton button = new JButton(new ImageIcon(iconResource));
        button.setToolTipText("stop test plan");
        button.addActionListener(e -> {
            button.setEnabled(false);
            testRunner.stop();
        });
        testRunner.addEndListener(() -> button.setEnabled(false));
        return button;
    }

    public void awaitAllClosedVisualizers(List<Future<Void>> closedVisualizers) {
        try {
            for (Future<Void> closedVisualizer : closedVisualizers) {
                try {
                    closedVisualizer.get();
                }
                catch (ExecutionException e) {
                    LOG.warn("Problem waiting for a visualizer to close", e);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }

    public static abstract class TestRunner {
        private final List<Runnable> listeners = new ArrayList<Runnable>();

        public void run() {
            try {
                this.runTest();
            }
            finally {
                this.listeners.forEach(Runnable::run);
            }
        }

        protected abstract void runTest();

        public abstract void stop();

        public void addEndListener(Runnable listener) {
            this.listeners.add(listener);
        }
    }
}

