/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.engines;

import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.apache.jmeter.JMeter;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.MainFrame;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.action.Load;
import org.apache.jmeter.gui.action.LookAndFeelCommand;
import org.apache.jmeter.gui.tree.JMeterTreeListener;
import org.apache.jmeter.gui.tree.JMeterTreeModel;
import org.apache.jmeter.plugin.PluginManager;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.gui.ComponentUtil;
import org.apache.jorphan.gui.JMeterUIDefaults;

public class JmeterGui {
    private final CountDownLatch closeLatch = new CountDownLatch(1);

    public JmeterGui() throws IOException {
        this.initLookAndFeel();
        this.loadUiResources();
        this.openFrame();
    }

    private void initLookAndFeel() {
        JMeterUIDefaults.INSTANCE.install();
        String jMeterLaf = LookAndFeelCommand.getPreferredLafCommand();
        LookAndFeelCommand.activateLookAndFeel(jMeterLaf);
        JMeterUtils.applyHiDPIOnFonts();
    }

    private void loadUiResources() {
        PluginManager.install(new JMeter(), true);
    }

    private void openFrame() {
        JMeterTreeModel treeModel = new JMeterTreeModel();
        JMeterTreeListener treeListener = new JMeterTreeListener(treeModel);
        ActionRouter actionRouter = ActionRouter.getInstance();
        actionRouter.populateCommandMap();
        treeListener.setActionHandler(actionRouter);
        GuiPackage.initInstance(treeListener, treeModel);
        MainFrame frame = new MainFrame(treeModel, treeListener);
        frame.setDefaultCloseOperation(2);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                super.windowClosed(e);
                JmeterGui.this.closeLatch.countDown();
            }
        });
        ComponentUtil.centerComponentInWindow(frame, 80);
        frame.setVisible(true);
        frame.toFront();
        actionRouter.actionPerformed(new ActionEvent(frame, 1, "add_all"));
    }

    public void load(HashTree tree) throws IllegalUserActionException {
        Load.insertLoadedTree(1, tree);
    }

    public void awaitClose() throws InterruptedException {
        this.closeLatch.await();
    }
}

