/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.listeners;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.visualizers.backend.influxdb.InfluxdbBackendListenerClient;
import us.abstracta.jmeter.javadsl.core.listeners.DslBackendListener;

public class InfluxDbBackendListener
extends DslBackendListener {
    private String title = "Test jmeter-java-dsl " + Instant.now().toString();
    private String token;
    private final Map<String, String> tags = new HashMap<String, String>();
    private String samplersRegex;
    private String measurement;
    private String applicationName;

    public InfluxDbBackendListener(String url) {
        super(InfluxdbBackendListenerClient.class, url);
    }

    public InfluxDbBackendListener title(String title) {
        this.title = title;
        return this;
    }

    public InfluxDbBackendListener token(String token) {
        this.token = token;
        return this;
    }

    public InfluxDbBackendListener queueSize(int queueSize) {
        this.setQueueSize(queueSize);
        return this;
    }

    public InfluxDbBackendListener tag(String name, String value) {
        this.tags.put(name, value);
        return this;
    }

    public InfluxDbBackendListener measurement(String measurement) {
        this.measurement = measurement;
        return this;
    }

    public InfluxDbBackendListener application(String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    public InfluxDbBackendListener samplersRegex(String samplersRegex) {
        this.samplersRegex = samplersRegex;
        return this;
    }

    @Override
    protected Arguments buildListenerArguments() {
        Arguments ret = new Arguments();
        ret.addArgument("influxdbUrl", this.url);
        ret.addArgument("summaryOnly", "false");
        ret.addArgument("testTitle", this.title);
        if (this.measurement != null) {
            ret.addArgument("measurement", this.measurement);
        }
        if (this.applicationName != null) {
            ret.addArgument("application", this.applicationName);
        }
        if (this.samplersRegex != null) {
            ret.addArgument("samplersRegex", this.samplersRegex);
        }
        if (this.token != null) {
            ret.addArgument("influxdbToken", this.token);
        }
        this.tags.forEach((name, value) -> ret.addArgument("TAG_" + name, (String)value));
        return ret;
    }
}

