/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.postprocessors;

import org.apache.jmeter.extractor.RegexExtractor;
import org.apache.jmeter.extractor.gui.RegexExtractorGui;
import org.apache.jmeter.testelement.TestElement;
import us.abstracta.jmeter.javadsl.core.postprocessors.DslVariableExtractor;

public class DslRegexExtractor
extends DslVariableExtractor<DslRegexExtractor> {
    private final String regex;
    private String template = "$1$";
    private TargetField fieldToCheck = TargetField.RESPONSE_BODY;

    public DslRegexExtractor(String varName, String regex) {
        super("Regular Expression Extractor", RegexExtractorGui.class, varName);
        this.regex = regex;
    }

    public DslRegexExtractor matchNumber(int matchNumber) {
        this.matchNumber = matchNumber;
        return this;
    }

    public DslRegexExtractor template(String template) {
        this.template = template;
        return this;
    }

    public DslRegexExtractor defaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public DslRegexExtractor fieldToCheck(TargetField fieldToCheck) {
        this.fieldToCheck = fieldToCheck;
        return this;
    }

    @Override
    protected TestElement buildTestElement() {
        RegexExtractor ret = new RegexExtractor();
        this.setScopeTo(ret);
        ret.setUseField(this.fieldToCheck.propertyValue);
        ret.setRefName(this.varName);
        ret.setRegex(this.regex);
        ret.setMatchNumber(this.matchNumber);
        ret.setTemplate(this.template);
        if (this.defaultValue != null) {
            if (this.defaultValue.isEmpty()) {
                ret.setDefaultEmptyValue(true);
            } else {
                ret.setDefaultValue(this.defaultValue);
            }
        }
        return ret;
    }

    public static enum TargetField {
        RESPONSE_BODY("false"),
        RESPONSE_BODY_UNESCAPED("unescaped"),
        RESPONSE_BODY_AS_DOCUMENT("as_document"),
        RESPONSE_HEADERS("true"),
        REQUEST_HEADERS("request_headers"),
        REQUEST_URL("URL"),
        RESPONSE_CODE("code"),
        RESPONSE_MESSAGE("message");

        private final String propertyValue;

        private TargetField(String propertyValue) {
            this.propertyValue = propertyValue;
        }
    }
}

