/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.testelements;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import javax.swing.JFrame;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.testbeans.TestBeanHelper;
import org.apache.jmeter.testbeans.gui.TestBeanGUI;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.AbstractProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jorphan.collections.HashTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.abstracta.jmeter.javadsl.core.BuildTreeContext;
import us.abstracta.jmeter.javadsl.core.DslTestElement;
import us.abstracta.jmeter.javadsl.core.engines.JmeterEnvironment;

public abstract class BaseTestElement
implements DslTestElement {
    private static final Logger LOG = LoggerFactory.getLogger(BaseTestElement.class);
    protected final String name;
    protected Class<? extends JMeterGUIComponent> guiClass;

    protected BaseTestElement(String name, Class<? extends JMeterGUIComponent> guiClass) {
        this.name = name;
        this.guiClass = guiClass;
    }

    @Override
    public HashTree buildTreeUnder(HashTree parent, BuildTreeContext context) {
        return parent.add(this.buildConfiguredTestElement());
    }

    protected TestElement buildConfiguredTestElement() {
        TestElement ret = this.buildTestElement();
        return BaseTestElement.configureTestElement(ret, this.name, this.guiClass);
    }

    protected static TestElement configureTestElement(TestElement ret, String name, Class<? extends JMeterGUIComponent> guiClass) {
        ret.setName(name);
        if (guiClass != null) {
            ret.setProperty("TestElement.gui_class", guiClass.getName());
        }
        ret.setProperty("TestElement.test_class", ret.getClass().getName());
        if (guiClass == TestBeanGUI.class) {
            BaseTestElement.loadBeanProperties(ret);
        }
        return ret;
    }

    protected abstract TestElement buildTestElement();

    private static void loadBeanProperties(TestElement bean) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
            for (PropertyDescriptor prop : beanInfo.getPropertyDescriptors()) {
                if (TestBeanHelper.isDescriptorIgnored(prop)) continue;
                try {
                    JMeterProperty jprop = AbstractProperty.createProperty(prop.getReadMethod().invoke((Object)bean, new Object[0]));
                    jprop.setName(prop.getName());
                    bean.setProperty(jprop);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    LOG.error("Could not set property {} for bean {}", (Object)prop.getName(), (Object)bean);
                }
            }
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void showInGui() {
        try {
            new JmeterEnvironment().initLocale();
            CountDownLatch countDownLatch = new CountDownLatch(1);
            this.showTestElementGui(this.buildTestElementGui(this.buildConfiguredTestElement()), countDownLatch::countDown);
            countDownLatch.await();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    protected Component buildTestElementGui(TestElement testElement) {
        try {
            Class<?> guiClass = Class.forName(testElement.getPropertyAsString("TestElement.gui_class"));
            JMeterGUIComponent gui = guiClass == TestBeanGUI.class ? new TestBeanGUI(testElement.getClass()) : (JMeterGUIComponent)guiClass.newInstance();
            gui.clearGui();
            gui.configure(testElement);
            gui.modifyTestElement(testElement);
            return (Component)((Object)gui);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public void showTestElementGui(Component guiComponent, Runnable closeListener) {
        this.showFrameWith(guiComponent, this.name, 800, 600, closeListener);
    }

    protected void showFrameWith(Component content, String title, int width, int height, final Runnable closeListener) {
        JFrame frame = new JFrame(title);
        frame.setDefaultCloseOperation(closeListener != null ? 2 : 3);
        if (closeListener != null) {
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    super.windowClosed(e);
                    closeListener.run();
                }
            });
        }
        frame.setLocation(200, 200);
        frame.setSize(width, height);
        frame.add(content);
        frame.setVisible(true);
    }

    protected static long durationToSeconds(Duration duration) {
        return Math.round(Math.ceil((double)duration.toMillis() / 1000.0));
    }
}

