/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.octoperf;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.ListedHashTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.abstracta.jmeter.javadsl.core.BuildTreeContext;
import us.abstracta.jmeter.javadsl.core.DslJmeterEngine;
import us.abstracta.jmeter.javadsl.core.DslTestElement;
import us.abstracta.jmeter.javadsl.core.DslTestPlan;
import us.abstracta.jmeter.javadsl.core.TestPlanStats;
import us.abstracta.jmeter.javadsl.core.engines.JmeterEnvironment;
import us.abstracta.jmeter.javadsl.octoperf.OctoPerfClient;
import us.abstracta.jmeter.javadsl.octoperf.OctoPerfTestPlanStats;
import us.abstracta.jmeter.javadsl.octoperf.api.BenchReport;
import us.abstracta.jmeter.javadsl.octoperf.api.BenchResult;
import us.abstracta.jmeter.javadsl.octoperf.api.Project;
import us.abstracta.jmeter.javadsl.octoperf.api.Provider;
import us.abstracta.jmeter.javadsl.octoperf.api.Scenario;
import us.abstracta.jmeter.javadsl.octoperf.api.TableEntry;
import us.abstracta.jmeter.javadsl.octoperf.api.User;
import us.abstracta.jmeter.javadsl.octoperf.api.UserLoad;
import us.abstracta.jmeter.javadsl.octoperf.api.VirtualUser;
import us.abstracta.jmeter.javadsl.octoperf.api.Workspace;

public class OctoPerfEngine
implements DslJmeterEngine {
    private static final Logger LOG = LoggerFactory.getLogger(OctoPerfEngine.class);
    private static final String TAG = "jmeter-java-dsl";
    private static final Set<String> TAGS = Collections.singleton("jmeter-java-dsl");
    private static final Duration STATUS_POLL_PERIOD = Duration.ofSeconds(5L);
    private static final Duration STATISTICS_POLL_PERIOD = Duration.ofSeconds(30L);
    private final String apiKey;
    private String projectName = "jmeter-java-dsl";
    private int totalUsers = 1;
    private Duration rampUp = Duration.ZERO;
    private Duration holdFor = Duration.ofSeconds(10L);
    private Duration testTimeout = Duration.ofHours(1L);
    private boolean projectCleanUp = true;

    public OctoPerfEngine(String apiKey) {
        this.apiKey = apiKey;
    }

    public OctoPerfEngine projectName(String projectName) {
        this.projectName = projectName;
        return this;
    }

    public OctoPerfEngine totalUsers(int totalUsers) {
        this.totalUsers = totalUsers;
        return this;
    }

    public OctoPerfEngine rampUpFor(Duration rampUp) {
        this.rampUp = rampUp;
        return this;
    }

    public OctoPerfEngine holdFor(Duration holdFor) {
        this.holdFor = holdFor;
        return this;
    }

    public OctoPerfEngine testTimeout(Duration testTimeout) {
        this.testTimeout = testTimeout;
        return this;
    }

    public OctoPerfEngine projectCleanUp(boolean enabled) {
        this.projectCleanUp = enabled;
        return this;
    }

    /*
     * Loose catch block
     */
    public TestPlanStats run(DslTestPlan testPlan) throws IOException, InterruptedException, TimeoutException {
        File jmxFile = Files.createTempFile("jmeter-dsl", "test.jmx", new FileAttribute[0]).toFile();
        try {
            try (OctoPerfClient client = new OctoPerfClient(this.apiKey);){
                User user = client.findCurrentUser();
                Project project = this.findProject(user, client);
                if (this.projectCleanUp) {
                    this.cleanUpProject(project, client);
                }
                this.saveTestPlanTo(testPlan, jmxFile);
                LOG.info("Importing JMX file into project...");
                List<VirtualUser> vus = client.importJmx(project, jmxFile);
                vus.forEach(vu -> LOG.info("Created virtual user {}", (Object)vu.getUrl()));
                this.tagVirtualUsers(vus, client);
                Scenario scenario = this.buildScenario(user, project, vus, client);
                BenchReport report = client.runScenario(scenario);
                LOG.info("Running scenario in {}", (Object)report.getUrl());
                Instant testStart = Instant.now();
                BenchResult result = this.awaitTestEnd(report, testStart, client);
                TestPlanStats testPlanStats = this.findTestPlanStats(report, testStart, vus, result, client);
                return testPlanStats;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            jmxFile.delete();
        }
    }

    private Project findProject(User user, OctoPerfClient client) throws IOException {
        LOG.info("Looking up project with name '{}'...", (Object)this.projectName);
        Workspace workspace = client.findDefaultWorkspace();
        Optional<Project> foundProject = client.findProjectByWorkspaceAndName(workspace, this.projectName);
        if (foundProject.isPresent()) {
            LOG.info("Found project {}", (Object)foundProject.get().getUrl());
            return foundProject.get();
        }
        Project ret = client.createProject(new Project(user, workspace, this.projectName, TAGS));
        LOG.info("Created project {}", (Object)ret.getUrl());
        return ret;
    }

    private void cleanUpProject(Project project, OctoPerfClient client) throws IOException {
        LOG.info("Deleting previously generated virtual users and scenarios from project to avoid piling them up...");
        List<VirtualUser> vus = client.findVirtualUsersByProject(project);
        for (VirtualUser vu : vus) {
            if (!vu.getTags().contains(TAG)) continue;
            try {
                client.deleteVirtualUser(vu);
            }
            catch (IOException e) {
                LOG.warn("Problem deleting virtual user {}" + vu.getUrl(), (Throwable)e);
            }
        }
        List<Scenario> scenarios = client.findScenariosByProject(project);
        for (Scenario scenario : scenarios) {
            if (!scenario.getTags().contains(TAG)) continue;
            try {
                client.deleteScenario(scenario);
            }
            catch (IOException e) {
                LOG.warn("Problem deleting scenario {}" + scenario.getUrl(), (Throwable)e);
            }
        }
    }

    private void saveTestPlanTo(DslTestPlan testPlan, File jmxFile) throws IOException {
        JmeterEnvironment env = new JmeterEnvironment();
        try (FileOutputStream output = new FileOutputStream(jmxFile.getPath());){
            ListedHashTree tree = new ListedHashTree();
            BuildTreeContext context = new BuildTreeContext();
            context.buildTreeFor((DslTestElement)testPlan, (HashTree)tree);
            env.saveTree((HashTree)tree, output);
            context.getVisualizers().forEach((v, e) -> LOG.warn("OctoPerfEngine does not currently support displaying visualizers. Ignoring {}.", (Object)v.getClass().getSimpleName()));
        }
    }

    private void tagVirtualUsers(List<VirtualUser> vus, OctoPerfClient client) throws IOException {
        for (VirtualUser vu : vus) {
            vu.getTags().add(TAG);
            client.updateVirtualUser(vu);
        }
    }

    private Scenario buildScenario(User user, Project project, List<VirtualUser> vus, OctoPerfClient client) throws IOException {
        Provider provider = client.findProviderByWorkspace(project.getWorkspace());
        String defaultRegion = provider.getRegions().keySet().iterator().next();
        List<UserLoad> userLoads = vus.stream().map(vu -> new UserLoad(vu.getId(), provider.getId(), defaultRegion, new UserLoad.UserLoadRampUp(this.totalUsers, this.rampUp.toMillis(), this.holdFor.toMillis()))).collect(Collectors.toList());
        Scenario ret = client.createScenario(new Scenario(user, project, this.projectName, userLoads, TAGS));
        LOG.info("Created scenario {}", (Object)ret.getUrl());
        return ret;
    }

    private BenchResult awaitTestEnd(BenchReport report, Instant testStart, OctoPerfClient client) throws InterruptedException, IOException, TimeoutException {
        BenchResult result;
        String resultId = report.getBenchResultIds().get(0);
        BenchResult.State status = BenchResult.State.CREATED;
        do {
            Thread.sleep(STATUS_POLL_PERIOD.toMillis());
            result = client.findBenchResult(resultId);
            if (status.equals((Object)result.getState())) continue;
            LOG.debug("Test run {} status changed to: {}", (Object)report.getUrl(), (Object)result.getState());
            status = result.getState();
        } while (!status.isFinalState() && !this.hasTimedOut(testStart, this.testTimeout));
        if (!status.isFinalState()) {
            throw this.buildTestTimeoutException(report);
        }
        if (status == BenchResult.State.ERROR) {
            throw new IllegalStateException("Execution of test failed, please check OctoPerf logs for more details: " + report.getUrl());
        }
        if (status == BenchResult.State.ABORTED) {
            throw new IllegalStateException("Execution of the test was aborted, probably to some users stopping it from OctoPerf  site. Check OctoPerf test execution for more details: " + report.getUrl());
        }
        return result;
    }

    private boolean hasTimedOut(Instant start, Duration timeout) {
        return Duration.between(start, Instant.now()).compareTo(timeout) >= 0;
    }

    private TimeoutException buildTestTimeoutException(BenchReport report) {
        return new TimeoutException(String.format("Test %s didn't end after %s. If the timeout is too short, you can change it with testTimeout() method.", report.getUrl(), this.testTimeout));
    }

    private TestPlanStats findTestPlanStats(BenchReport report, Instant testStart, List<VirtualUser> vus, BenchResult result, OctoPerfClient client) throws IOException, TimeoutException, InterruptedException {
        double[] prevStats;
        List<BenchReport.ReportMetricId> metrics = Arrays.asList(BenchReport.ReportMetricId.HITS_TOTAL, BenchReport.ReportMetricId.HITS_RATE, BenchReport.ReportMetricId.ERRORS_TOTAL, BenchReport.ReportMetricId.ERRORS_RATE, BenchReport.ReportMetricId.RESPONSE_TIME_AVG, BenchReport.ReportMetricId.RESPONSE_TIME_MIN, BenchReport.ReportMetricId.RESPONSE_TIME_MAX, BenchReport.ReportMetricId.RESPONSE_TIME_MEDIAN, BenchReport.ReportMetricId.RESPONSE_TIME_PERCENTILE_90, BenchReport.ReportMetricId.RESPONSE_TIME_PERCENTILE_95, BenchReport.ReportMetricId.RESPONSE_TIME_PERCENTILE_99, BenchReport.ReportMetricId.THROUGHPUT_TOTAL, BenchReport.ReportMetricId.THROUGHPUT_RATE, BenchReport.ReportMetricId.SENT_BYTES_TOTAL, BenchReport.ReportMetricId.SENT_BYTES_RATE);
        BenchReport.SummaryReportItem summaryReport = OctoPerfEngine.findReportItemWithType(BenchReport.SummaryReportItem.class, report.getItems());
        OctoPerfEngine.setReportMetrics(summaryReport, metrics);
        double[] summaryStats = client.findSummaryStats(summaryReport);
        do {
            Thread.sleep(STATISTICS_POLL_PERIOD.toMillis());
            prevStats = summaryStats;
        } while (!Arrays.equals(summaryStats = client.findSummaryStats(summaryReport), prevStats) && !this.hasTimedOut(testStart, this.testTimeout));
        if (this.hasTimedOut(testStart, this.testTimeout)) {
            throw this.buildTestTimeoutException(report);
        }
        BenchReport.StatisticTableReportItem tableReport = OctoPerfEngine.findReportItemWithType(BenchReport.StatisticTableReportItem.class, report.getItems());
        OctoPerfEngine.setReportMetrics(tableReport, metrics);
        List<TableEntry> tableStats = client.findTableStats(tableReport);
        return new OctoPerfTestPlanStats(summaryStats, tableStats, vus, result);
    }

    private static <T extends BenchReport.BenchReportItem> T findReportItemWithType(Class<T> reportItemClass, List<BenchReport.BenchReportItem> items) {
        return (T)items.stream().filter(reportItemClass::isInstance).map(reportItemClass::cast).findAny().get();
    }

    private static void setReportMetrics(BenchReport.BenchReportItem summaryReport, List<BenchReport.ReportMetricId> metricIds) {
        List<BenchReport.ReportItemMetric> metrics = summaryReport.getMetrics();
        String benchResultId = metrics.get(0).getBenchResultId();
        metrics.clear();
        metricIds.forEach(m -> metrics.add(new BenchReport.ReportItemMetric((BenchReport.ReportMetricId)((Object)m), benchResultId)));
    }
}

