/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.octoperf;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.jmeter.samplers.SampleResult;
import us.abstracta.jmeter.javadsl.core.TestPlanStats;
import us.abstracta.jmeter.javadsl.core.stats.CountMetricSummary;
import us.abstracta.jmeter.javadsl.core.stats.StatsSummary;
import us.abstracta.jmeter.javadsl.core.stats.TimeMetricSummary;
import us.abstracta.jmeter.javadsl.octoperf.api.BenchResult;
import us.abstracta.jmeter.javadsl.octoperf.api.TableEntry;
import us.abstracta.jmeter.javadsl.octoperf.api.VirtualUser;

public class OctoPerfTestPlanStats
extends TestPlanStats {
    public OctoPerfTestPlanStats(double[] summaryStats, List<TableEntry> tableStats, List<VirtualUser> vus, BenchResult result) {
        super(() -> null);
        this.setStart(result.getCreated());
        this.setEnd(result.getLastModified());
        this.overallStats = new OctoPerfStatsSummary(result, summaryStats);
        Map<String, String> actionsLabels = vus.stream().flatMap(vu -> vu.getChildren().stream()).collect(Collectors.toMap(VirtualUser.Action::getId, VirtualUser.Action::getName));
        this.labeledStats.putAll(tableStats.stream().collect(Collectors.toMap(s -> (String)actionsLabels.get(s.getActionId()), s -> new OctoPerfStatsSummary(result, (TableEntry)s), OctoPerfStatsSummary::new)));
    }

    public static class OctoPerfTime
    implements TimeMetricSummary {
        private final Duration mean;
        private final Duration min;
        private final Duration max;
        private final Duration median;
        private final Duration perc90;
        private final Duration perc95;
        private final Duration perc99;

        public OctoPerfTime(double mean, double min, double max, double median, double perc90, double perc95, double perc99) {
            this.mean = this.durationFromSecs(mean);
            this.min = this.durationFromSecs(min);
            this.max = this.durationFromSecs(max);
            this.median = this.durationFromSecs(median);
            this.perc90 = this.durationFromSecs(perc90);
            this.perc95 = this.durationFromSecs(perc95);
            this.perc99 = this.durationFromSecs(perc99);
        }

        public OctoPerfTime(OctoPerfTime time1, OctoPerfTime time2, long count1, long count2) {
            this.mean = this.weightedDuration(time1.mean, time2.mean, count1, count2);
            this.min = time1.min.compareTo(time2.min) < 0 ? time1.min : time2.min;
            this.max = time1.max.compareTo(time2.max) > 0 ? time1.max : time2.max;
            this.median = this.weightedDuration(time1.median, time2.median, count1, count2);
            this.perc90 = this.weightedDuration(time1.perc90, time2.perc90, count1, count2);
            this.perc95 = this.weightedDuration(time1.perc95, time2.perc95, count1, count2);
            this.perc99 = this.weightedDuration(time1.perc99, time2.perc99, count1, count2);
        }

        private Duration durationFromSecs(double secs) {
            return Duration.ofMillis(Math.round(secs * 1000.0));
        }

        private Duration weightedDuration(Duration d1, Duration d2, long w1, long w2) {
            return Duration.ofMillis(Math.round((double)d1.toMillis() * (double)w1 + (double)d2.toMillis() * (double)w2) / (w1 + w2));
        }

        public Duration mean() {
            return this.mean;
        }

        public Duration min() {
            return this.min;
        }

        public Duration max() {
            return this.max;
        }

        public Duration median() {
            return this.median;
        }

        public Duration perc90() {
            return this.perc90;
        }

        public Duration perc95() {
            return this.perc95;
        }

        public Duration perc99() {
            return this.perc99;
        }
    }

    public static class OctoPerfCount
    extends CountMetricSummary {
        private final long total;
        private final double rate;

        private OctoPerfCount(double total, double rate) {
            this.total = Math.round(total);
            this.rate = rate;
        }

        public OctoPerfCount(OctoPerfCount s1, OctoPerfCount s2) {
            this.total = s1.total + s2.total;
            this.rate = s1.rate + s2.rate;
        }

        public long total() {
            return this.total;
        }

        public double perSecond() {
            return this.rate;
        }
    }

    public static class OctoPerfStatsSummary
    implements StatsSummary {
        private final Instant startTime;
        private final Instant endTime;
        private final OctoPerfCount samples;
        private final OctoPerfCount errors;
        private final OctoPerfTime sampleTime;
        private final OctoPerfCount receivedBytes;
        private final OctoPerfCount sentBytes;

        public OctoPerfStatsSummary(BenchResult result, double[] summaryStats) {
            this.startTime = result.getCreated();
            this.endTime = result.getLastModified();
            int statIndex = 0;
            this.samples = new OctoPerfCount(summaryStats[statIndex++], summaryStats[statIndex++]);
            this.errors = new OctoPerfCount(summaryStats[statIndex++], summaryStats[statIndex++]);
            this.sampleTime = new OctoPerfTime(summaryStats[statIndex++], summaryStats[statIndex++], summaryStats[statIndex++], summaryStats[statIndex++], summaryStats[statIndex++], summaryStats[statIndex++], summaryStats[statIndex++]);
            this.receivedBytes = new OctoPerfCount(summaryStats[statIndex++], summaryStats[statIndex++]);
            this.sentBytes = new OctoPerfCount(summaryStats[statIndex++], summaryStats[statIndex]);
        }

        public OctoPerfStatsSummary(BenchResult result, TableEntry s) {
            this(result, s.getValues().stream().mapToDouble(TableEntry.TableValue::getValue).toArray());
        }

        public OctoPerfStatsSummary(OctoPerfStatsSummary s1, OctoPerfStatsSummary s2) {
            this.startTime = s1.startTime.isBefore(s2.startTime) ? s1.startTime : s2.startTime;
            this.endTime = s1.endTime.isAfter(s2.endTime) ? s1.endTime : s2.endTime;
            this.samples = new OctoPerfCount(s1.samples, s2.samples);
            this.errors = new OctoPerfCount(s1.errors, s2.errors);
            this.sampleTime = new OctoPerfTime(s1.sampleTime, s2.sampleTime, s1.samples.total(), s2.samples.total());
            this.receivedBytes = new OctoPerfCount(s1.receivedBytes, s2.receivedBytes);
            this.sentBytes = new OctoPerfCount(s1.sentBytes, s2.sentBytes);
        }

        public void add(SampleResult result) {
        }

        public Instant firstTime() {
            return this.startTime;
        }

        public Instant endTime() {
            return this.endTime;
        }

        public CountMetricSummary samples() {
            return this.samples;
        }

        public CountMetricSummary errors() {
            return this.errors;
        }

        public TimeMetricSummary sampleTime() {
            return this.sampleTime;
        }

        public CountMetricSummary receivedBytes() {
            return this.receivedBytes;
        }

        public CountMetricSummary sentBytes() {
            return this.sentBytes;
        }
    }
}

