/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.octoperf.api;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import us.abstracta.jmeter.javadsl.core.threadgroups.BaseThreadGroup;

public class UserLoad {
    private final String name = "";
    private final String virtualUserId;
    private final String providerId;
    private final String region;
    private final UserLoadStrategy strategy;
    private final BandwidthSettings bandwidth = new BandwidthSettings();
    private final BrowserSettings browser = new BrowserSettings();
    private final DnsSettings dns = new DnsSettings();
    private final ThinkTimeSettings thinktime = new ThinkTimeSettings();
    private final MemorySettings memory = new MemorySettings();
    private final JtlSettings jtl = new JtlSettings();
    private final PropertiesSettings properties = new PropertiesSettings();
    private final SetUpTearDownSettings setUp = null;
    private final SetUpTearDownSettings tearDown = null;

    public UserLoad() {
        this.virtualUserId = null;
        this.providerId = null;
        this.region = null;
        this.strategy = null;
    }

    public UserLoad(String virtualUserId, String providerId, String region, UserLoadStrategy strategy) {
        this.virtualUserId = virtualUserId;
        this.providerId = providerId;
        this.region = region;
        this.strategy = strategy;
    }

    public static class PropertiesSettings {
        private final Map<String, String> map = Collections.emptyMap();
    }

    public static class JtlSettings {
        private final String type = "ALL";
        private final List<String> settings = Collections.emptyList();
    }

    public static class MemorySettings {
        private final Double vuMb = null;
    }

    public static class PacingSettings {
    }

    public static class ThinkTime {
    }

    public static class ThinkTimeSettings {
        private final ThinkTime thinktime = null;
        private final PacingSettings pacing = null;
    }

    public static class DnsSettings {
        private final boolean clearEachIteration = false;
        private final List<String> servers = Collections.emptyList();
        private final Map<String, String> staticHosts = Collections.emptyMap();
    }

    public static class CookiesManager {
        private final boolean clearOnEachIteration = true;
        private final String policy = "STANDARD";
    }

    public static class CacheManager {
        private final int cacheSize = 5000;
        private final boolean clearCacheOnEachIteration = true;
        private final boolean useCacheControlHeaders = false;
    }

    public static class BrowserSettings {
        private final String name = "AS_RECORDED";
        private final String userAgent = "";
        private final CacheManager cache = new CacheManager();
        private final CookiesManager cookies = new CookiesManager();
    }

    public static class BandwidthSettings {
        private final String name = "UNLIMITED";
        private final int bitsPerSecond = 0;
    }

    public static class SetUpTearDownSettings {
    }

    @JsonTypeName(value="UserLoadRampup")
    public static class UserLoadRampUp
    extends UserLoadStrategy {
        private final int userload;
        private final long rampup;
        private final long peak;
        private final long delay = 0L;
        private final BaseThreadGroup.SampleErrorAction onSampleError = BaseThreadGroup.SampleErrorAction.CONTINUE;

        public UserLoadRampUp() {
            this.userload = 0;
            this.rampup = 0L;
            this.peak = 0L;
        }

        public UserLoadRampUp(int userLoad, long rampUpMillis, long peakMillis) {
            this.userload = userLoad;
            this.rampup = rampUpMillis;
            this.peak = peakMillis;
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=UserLoadRampUp.class)})
    public static abstract class UserLoadStrategy {
    }
}

