/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.octoperf;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Part;
import retrofit2.http.Path;
import retrofit2.http.Query;
import us.abstracta.jmeter.javadsl.engines.BaseRemoteEngineApiClient;
import us.abstracta.jmeter.javadsl.engines.RemoteEngineException;
import us.abstracta.jmeter.javadsl.octoperf.OctoPerfException;
import us.abstracta.jmeter.javadsl.octoperf.api.BenchReport;
import us.abstracta.jmeter.javadsl.octoperf.api.BenchResult;
import us.abstracta.jmeter.javadsl.octoperf.api.Project;
import us.abstracta.jmeter.javadsl.octoperf.api.Provider;
import us.abstracta.jmeter.javadsl.octoperf.api.Scenario;
import us.abstracta.jmeter.javadsl.octoperf.api.TableEntry;
import us.abstracta.jmeter.javadsl.octoperf.api.User;
import us.abstracta.jmeter.javadsl.octoperf.api.VirtualUser;
import us.abstracta.jmeter.javadsl.octoperf.api.Workspace;

public class OctoPerfClient
extends BaseRemoteEngineApiClient {
    private static final Logger LOG = LoggerFactory.getLogger(OctoPerfClient.class);
    private static final String BASE_URL = "https://api.octoperf.com";
    private static final String BASE_APP_URL = "https://api.octoperf.com/app/#/app";
    private final OctoPerfApi api;
    private final String apiKey;

    public OctoPerfClient(String apiKey) {
        super(LOG);
        this.apiKey = apiKey;
        this.api = (OctoPerfApi)this.buildApiFor(BASE_URL, OctoPerfApi.class);
    }

    protected String buildAuthorizationHeaderValue(Request request) {
        return "Bearer " + this.apiKey;
    }

    protected ObjectMapper buildConverterMapper() {
        return super.buildConverterMapper().configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
    }

    protected RemoteEngineException buildRemoteEngineException(int code, String message) {
        return new OctoPerfException(code, message);
    }

    public User findCurrentUser() throws IOException {
        return (User)this.execApiCall(this.api.findCurrentUser());
    }

    public Workspace findDefaultWorkspace() throws IOException {
        Workspace ret = (Workspace)((List)this.execApiCall(this.api.findWorkspaces())).get(0);
        ret.setBaseAppUrl(BASE_APP_URL);
        return ret;
    }

    public Optional<Project> findProjectByWorkspaceAndName(Workspace workspace, String name) throws IOException {
        Optional<Project> ret = ((List)this.execApiCall(this.api.findProjectsByWorkspace(workspace.getId()))).stream().filter(p -> name.equalsIgnoreCase(p.getName())).findAny();
        ret.ifPresent(p -> p.setWorkspace(workspace));
        return ret;
    }

    public Project createProject(Project project) throws IOException {
        Project ret = (Project)this.execApiCall(this.api.createProject(project));
        ret.setWorkspace(project.getWorkspace());
        return ret;
    }

    public List<VirtualUser> findVirtualUsersByProject(Project project) throws IOException {
        List ret = (List)this.execApiCall(this.api.findVirtualUsersByProject(project.getId()));
        ret.forEach(v -> v.setProject(project));
        return ret;
    }

    public void deleteVirtualUser(VirtualUser virtualUser) throws IOException {
        this.execApiCall(this.api.deleteVirtualUser(virtualUser.getId()));
    }

    public List<Scenario> findScenariosByProject(Project project) throws IOException {
        List ret = (List)this.execApiCall(this.api.findScenariosByProject(project.getId()));
        ret.forEach(s -> s.setProject(project));
        return ret;
    }

    public void deleteScenario(Scenario scenario) throws IOException {
        this.execApiCall(this.api.deleteScenario(scenario.getId()));
    }

    public List<VirtualUser> importJmx(Project project, File jmxFile) throws IOException {
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.get((String)"application/octet-stream"), (File)jmxFile);
        MultipartBody.Part part = MultipartBody.Part.createFormData((String)"file", (String)jmxFile.getName(), (RequestBody)requestBody);
        List ret = (List)this.execApiCall(this.api.importJmx(project.getId(), part));
        ret.forEach(vu -> vu.setProject(project));
        return ret;
    }

    public void updateVirtualUser(VirtualUser vu) throws IOException {
        this.execApiCall(this.api.updateVirtualUser(vu.getId(), vu));
    }

    public Provider findProviderByWorkspace(Workspace workspace) throws IOException {
        return (Provider)((List)this.execApiCall(this.api.findProvidersByWorkspace(workspace.getId()))).get(0);
    }

    public Scenario createScenario(Scenario scenario) throws IOException {
        Scenario ret = (Scenario)this.execApiCall(this.api.createScenario(scenario));
        ret.setProject(scenario.getProject());
        return ret;
    }

    public BenchReport runScenario(Scenario scenario) throws IOException {
        BenchReport ret = (BenchReport)this.execApiCall(this.api.runScenario(scenario.getId()));
        ret.setProject(scenario.getProject());
        return ret;
    }

    public BenchResult findBenchResult(String resultId) throws IOException {
        return (BenchResult)this.execApiCall(this.api.findBenchResult(resultId));
    }

    public double[] findSummaryStats(BenchReport.SummaryReportItem summaryReport) throws IOException {
        return (double[])this.execApiCall(this.api.findSummaryStats(summaryReport));
    }

    public List<TableEntry> findTableStats(BenchReport.StatisticTableReportItem tableReport) throws IOException {
        return (List)this.execApiCall(this.api.findTableStats(tableReport));
    }

    private static interface OctoPerfApi {
        @GET(value="users/current")
        public Call<User> findCurrentUser();

        @GET(value="workspaces/member-of")
        public Call<List<Workspace>> findWorkspaces();

        @GET(value="design/projects/by-workspace/{workspaceId}/DESIGN")
        public Call<List<Project>> findProjectsByWorkspace(@Path(value="workspaceId") String var1);

        @POST(value="design/projects")
        public Call<Project> createProject(@Body Project var1);

        @POST(value="design/imports/jmx/{projectId}")
        @Multipart
        public Call<List<VirtualUser>> importJmx(@Path(value="projectId") String var1, @Part MultipartBody.Part var2);

        @GET(value="design/virtual-users/by-project/{projectId}")
        public Call<List<VirtualUser>> findVirtualUsersByProject(@Path(value="projectId") String var1);

        @DELETE(value="design/virtual-users/{virtualUserId}")
        public Call<Void> deleteVirtualUser(@Path(value="virtualUserId") String var1);

        @PUT(value="design/virtual-users/{virtualUserId}")
        public Call<Void> updateVirtualUser(@Path(value="virtualUserId") String var1, @Body VirtualUser var2);

        @GET(value="workspaces/docker-providers/public")
        public Call<List<Provider>> findProvidersByWorkspace(@Query(value="workspaceId") String var1);

        @POST(value="runtime/scenarios")
        public Call<Scenario> createScenario(@Body Scenario var1);

        @GET(value="runtime/scenarios/by-project/{projectId}")
        public Call<List<Scenario>> findScenariosByProject(@Path(value="projectId") String var1);

        @POST(value="runtime/scenarios/run/{scenarioId}")
        public Call<BenchReport> runScenario(@Path(value="scenarioId") String var1);

        @DELETE(value="runtime/scenarios/{scenarioId}")
        public Call<Void> deleteScenario(@Path(value="scenarioId") String var1);

        @GET(value="runtime/bench-results/{benchResultId}")
        public Call<BenchResult> findBenchResult(@Path(value="benchResultId") String var1);

        @POST(value="analysis/metrics/summary")
        public Call<double[]> findSummaryStats(@Body BenchReport.SummaryReportItem var1);

        @POST(value="analysis/metrics/table")
        public Call<List<TableEntry>> findTableStats(@Body BenchReport.StatisticTableReportItem var1);
    }
}

