/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.octoperf.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JsonNode;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import us.abstracta.jmeter.javadsl.octoperf.api.Project;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
public class VirtualUser {
    private final String id;
    private final String userId;
    private final String projectId;
    private final String name;
    private final String description;
    private final List<JsonNode> children;
    private final Instant created;
    private final Instant lastModified;
    private final String type;
    private final Set<String> tags;
    private String url;

    @JsonCreator
    private VirtualUser(@JsonProperty(value="id") String id, @JsonProperty(value="userId") String userId, @JsonProperty(value="projectId") String projectId, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="children") List<JsonNode> children, @JsonProperty(value="created") Instant created, @JsonProperty(value="lastModified") Instant lastModified, @JsonProperty(value="type") String type, @JsonProperty(value="tags") Set<String> tags) {
        this.id = id;
        this.userId = userId;
        this.projectId = projectId;
        this.name = name;
        this.description = description;
        this.children = children;
        this.created = created;
        this.lastModified = lastModified;
        this.type = type;
        this.tags = tags;
    }

    public String getId() {
        return this.id;
    }

    @JsonIgnore
    public List<Action> getChildren() {
        return this.children.stream().map(n -> new Action(n.get("id").textValue(), n.get("name").textValue())).collect(Collectors.toList());
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void setProject(Project project) {
        this.url = project.getUrl() + "/" + this.id;
    }

    @JsonIgnore
    public String getUrl() {
        return this.url;
    }

    public static class Action {
        private final String id;
        private final String name;

        public Action(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }
}

