/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.octoperf;

import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.jorphan.collections.HashTree;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.abstracta.jmeter.javadsl.core.BuildTreeContext;
import us.abstracta.jmeter.javadsl.engines.BaseRemoteEngine;
import us.abstracta.jmeter.javadsl.octoperf.OctoPerfClient;
import us.abstracta.jmeter.javadsl.octoperf.OctoPerfTestPlanStats;
import us.abstracta.jmeter.javadsl.octoperf.api.BenchReport;
import us.abstracta.jmeter.javadsl.octoperf.api.BenchResult;
import us.abstracta.jmeter.javadsl.octoperf.api.Project;
import us.abstracta.jmeter.javadsl.octoperf.api.Provider;
import us.abstracta.jmeter.javadsl.octoperf.api.Scenario;
import us.abstracta.jmeter.javadsl.octoperf.api.TableEntry;
import us.abstracta.jmeter.javadsl.octoperf.api.User;
import us.abstracta.jmeter.javadsl.octoperf.api.UserLoad;
import us.abstracta.jmeter.javadsl.octoperf.api.VirtualUser;
import us.abstracta.jmeter.javadsl.octoperf.api.Workspace;

public class OctoPerfEngine
extends BaseRemoteEngine<OctoPerfClient, OctoPerfTestPlanStats> {
    private static final Logger LOG = LoggerFactory.getLogger(OctoPerfEngine.class);
    private static final String TAG = "jmeter-java-dsl";
    private static final Set<String> TAGS = Collections.singleton("jmeter-java-dsl");
    private static final Duration STATUS_POLL_PERIOD = Duration.ofSeconds(5L);
    private static final Duration STATISTICS_POLL_PERIOD = Duration.ofSeconds(30L);
    private final String apiKey;
    private String projectName = "jmeter-java-dsl";
    private Integer totalUsers = null;
    private Duration rampUp = null;
    private Duration holdFor = null;
    private Duration testTimeout = Duration.ofHours(1L);
    private boolean projectCleanUp = true;

    public OctoPerfEngine(String apiKey) {
        this.apiKey = apiKey;
    }

    public OctoPerfEngine projectName(String projectName) {
        this.projectName = projectName;
        return this;
    }

    public OctoPerfEngine totalUsers(int totalUsers) {
        this.totalUsers = totalUsers;
        return this;
    }

    public OctoPerfEngine rampUpFor(Duration rampUp) {
        this.rampUp = rampUp;
        return this;
    }

    public OctoPerfEngine holdFor(Duration holdFor) {
        this.holdFor = holdFor;
        return this;
    }

    public OctoPerfEngine testTimeout(Duration testTimeout) {
        this.testTimeout = testTimeout;
        return this;
    }

    public OctoPerfEngine projectCleanUp(boolean enabled) {
        this.projectCleanUp = enabled;
        return this;
    }

    public OctoPerfTestPlanStats run(File jmxFile, HashTree tree, BuildTreeContext context) throws IOException, InterruptedException, TimeoutException {
        User user = ((OctoPerfClient)this.apiClient).findCurrentUser();
        Project project = this.findProject(user);
        if (this.projectCleanUp) {
            this.cleanUpProject(project, (OctoPerfClient)this.apiClient);
        }
        LOG.info("Importing JMX file into project...");
        List<VirtualUser> vus = ((OctoPerfClient)this.apiClient).importJmx(project, jmxFile);
        vus.forEach(vu -> LOG.info("Created virtual user {}", (Object)vu.getUrl()));
        this.tagVirtualUsers(vus);
        Scenario scenario = this.buildScenario(user, project, vus, tree);
        BenchReport report = ((OctoPerfClient)this.apiClient).runScenario(scenario);
        LOG.info("Running scenario in {}", (Object)report.getUrl());
        Instant testStart = Instant.now();
        BenchResult result = this.awaitTestEnd(report, testStart);
        return this.findTestPlanStats(report, testStart, vus, result);
    }

    protected OctoPerfClient buildClient() {
        return new OctoPerfClient(this.apiKey);
    }

    private Project findProject(User user) throws IOException {
        LOG.info("Looking up project with name '{}'...", (Object)this.projectName);
        Workspace workspace = ((OctoPerfClient)this.apiClient).findDefaultWorkspace();
        Optional<Project> foundProject = ((OctoPerfClient)this.apiClient).findProjectByWorkspaceAndName(workspace, this.projectName);
        if (foundProject.isPresent()) {
            LOG.info("Found project {}", (Object)foundProject.get().getUrl());
            return foundProject.get();
        }
        Project ret = ((OctoPerfClient)this.apiClient).createProject(new Project(user, workspace, this.projectName, TAGS));
        LOG.info("Created project {}", (Object)ret.getUrl());
        return ret;
    }

    private void cleanUpProject(Project project, OctoPerfClient client) throws IOException {
        LOG.info("Deleting previously generated virtual users and scenarios from project to avoid piling them up...");
        List<VirtualUser> vus = client.findVirtualUsersByProject(project);
        for (VirtualUser vu : vus) {
            if (!vu.getTags().contains(TAG)) continue;
            try {
                client.deleteVirtualUser(vu);
            }
            catch (IOException e) {
                LOG.warn("Problem deleting virtual user {}", (Object)vu.getUrl(), (Object)e);
            }
        }
        List<Scenario> scenarios = client.findScenariosByProject(project);
        for (Scenario scenario : scenarios) {
            if (!scenario.getTags().contains(TAG)) continue;
            try {
                client.deleteScenario(scenario);
            }
            catch (IOException e) {
                LOG.warn("Problem deleting scenario {}", (Object)scenario.getUrl(), (Object)e);
            }
        }
    }

    private void tagVirtualUsers(List<VirtualUser> vus) throws IOException {
        for (VirtualUser vu : vus) {
            vu.getTags().add(TAG);
            ((OctoPerfClient)this.apiClient).updateVirtualUser(vu);
        }
    }

    private Scenario buildScenario(User user, Project project, List<VirtualUser> vus, HashTree tree) throws IOException {
        Provider provider = ((OctoPerfClient)this.apiClient).findProviderByWorkspace(project.getWorkspace());
        String defaultRegion = provider.getRegions().keySet().iterator().next();
        List<UserLoad> userLoads = vus.stream().map(vu -> new UserLoad(vu.getId(), provider.getId(), defaultRegion, this.buildUserLoadConfig(tree))).collect(Collectors.toList());
        Scenario ret = ((OctoPerfClient)this.apiClient).createScenario(new Scenario(user, project, this.projectName, userLoads, TAGS));
        LOG.info("Created scenario {}", (Object)ret.getUrl());
        return ret;
    }

    @NotNull
    private UserLoad.UserLoadRampUp buildUserLoadConfig(HashTree tree) {
        return this.totalUsers == null && this.rampUp == null && this.holdFor == null ? UserLoad.UserLoadRampUp.fromThreadGroup(this.extractFirstThreadGroup(tree)) : new UserLoad.UserLoadRampUp(this.totalUsers != null ? this.totalUsers : 1, this.rampUp != null ? this.rampUp.toMillis() : 0L, this.holdFor != null ? this.holdFor.toMillis() : 10000L);
    }

    private BenchResult awaitTestEnd(BenchReport report, Instant testStart) throws InterruptedException, IOException, TimeoutException {
        BenchResult result;
        String resultId = report.getBenchResultIds().get(0);
        BenchResult.State status = BenchResult.State.CREATED;
        do {
            Thread.sleep(STATUS_POLL_PERIOD.toMillis());
            result = ((OctoPerfClient)this.apiClient).findBenchResult(resultId);
            if (status.equals((Object)result.getState())) continue;
            LOG.debug("Test run {} status changed to: {}", (Object)report.getUrl(), (Object)result.getState());
            status = result.getState();
        } while (!status.isFinalState() && !this.hasTimedOut(this.testTimeout, testStart));
        if (!status.isFinalState()) {
            throw this.buildTestTimeoutException(report);
        }
        if (status == BenchResult.State.ERROR) {
            throw new IllegalStateException("Execution of test failed, please check OctoPerf logs for more details: " + report.getUrl());
        }
        if (status == BenchResult.State.ABORTED) {
            throw new IllegalStateException("Execution of the test was aborted, probably to some users stopping it from OctoPerf  site. Check OctoPerf test execution for more details: " + report.getUrl());
        }
        return result;
    }

    private TimeoutException buildTestTimeoutException(BenchReport report) {
        return new TimeoutException(String.format("Test %s didn't end after %s. If the timeout is too short, you can change it with testTimeout() method.", report.getUrl(), this.testTimeout));
    }

    private OctoPerfTestPlanStats findTestPlanStats(BenchReport report, Instant testStart, List<VirtualUser> vus, BenchResult result) throws IOException, TimeoutException, InterruptedException {
        double[] prevStats;
        List<BenchReport.ReportMetricId> metrics = Arrays.asList(BenchReport.ReportMetricId.HITS_TOTAL, BenchReport.ReportMetricId.HITS_RATE, BenchReport.ReportMetricId.ERRORS_TOTAL, BenchReport.ReportMetricId.ERRORS_RATE, BenchReport.ReportMetricId.RESPONSE_TIME_AVG, BenchReport.ReportMetricId.RESPONSE_TIME_MIN, BenchReport.ReportMetricId.RESPONSE_TIME_MAX, BenchReport.ReportMetricId.RESPONSE_TIME_MEDIAN, BenchReport.ReportMetricId.RESPONSE_TIME_PERCENTILE_90, BenchReport.ReportMetricId.RESPONSE_TIME_PERCENTILE_95, BenchReport.ReportMetricId.RESPONSE_TIME_PERCENTILE_99, BenchReport.ReportMetricId.THROUGHPUT_TOTAL, BenchReport.ReportMetricId.THROUGHPUT_RATE, BenchReport.ReportMetricId.SENT_BYTES_TOTAL, BenchReport.ReportMetricId.SENT_BYTES_RATE);
        BenchReport.SummaryReportItem summaryReport = OctoPerfEngine.findReportItemWithType(BenchReport.SummaryReportItem.class, report.getItems());
        OctoPerfEngine.setReportMetrics(summaryReport, metrics);
        double[] summaryStats = ((OctoPerfClient)this.apiClient).findSummaryStats(summaryReport);
        do {
            Thread.sleep(STATISTICS_POLL_PERIOD.toMillis());
            prevStats = summaryStats;
        } while (!Arrays.equals(summaryStats = ((OctoPerfClient)this.apiClient).findSummaryStats(summaryReport), prevStats) && !this.hasTimedOut(this.testTimeout, testStart));
        if (this.hasTimedOut(this.testTimeout, testStart)) {
            throw this.buildTestTimeoutException(report);
        }
        BenchReport.StatisticTableReportItem tableReport = OctoPerfEngine.findReportItemWithType(BenchReport.StatisticTableReportItem.class, report.getItems());
        OctoPerfEngine.setReportMetrics(tableReport, metrics);
        List<TableEntry> tableStats = ((OctoPerfClient)this.apiClient).findTableStats(tableReport);
        return new OctoPerfTestPlanStats(summaryStats, tableStats, vus, result);
    }

    private static <T extends BenchReport.BenchReportItem> T findReportItemWithType(Class<T> reportItemClass, List<BenchReport.BenchReportItem> items) {
        return (T)items.stream().filter(reportItemClass::isInstance).map(reportItemClass::cast).findAny().get();
    }

    private static void setReportMetrics(BenchReport.BenchReportItem summaryReport, List<BenchReport.ReportMetricId> metricIds) {
        List<BenchReport.ReportItemMetric> metrics = summaryReport.getMetrics();
        String benchResultId = metrics.get(0).getBenchResultId();
        metrics.clear();
        metricIds.forEach(m -> metrics.add(new BenchReport.ReportItemMetric((BenchReport.ReportMetricId)((Object)m), benchResultId)));
    }
}

