/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.octoperf.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.util.Collections;
import java.util.Set;
import us.abstracta.jmeter.javadsl.octoperf.api.User;
import us.abstracta.jmeter.javadsl.octoperf.api.Workspace;

public class Project {
    private final String id;
    private final String userId;
    private final String workspaceId;
    private final String name;
    private final String description = "";
    private final String type = "DESIGN";
    private final Instant created = Instant.now();
    private final Instant lastModified = Instant.now();
    private final Set<String> tags;
    private Workspace workspace;

    @JsonCreator
    public Project(@JsonProperty(value="id") String id, @JsonProperty(value="userId") String userId, @JsonProperty(value="workspaceId") String workspaceId, @JsonProperty(value="name") String name) {
        this.id = id;
        this.userId = userId;
        this.workspaceId = workspaceId;
        this.name = name;
        this.tags = Collections.emptySet();
    }

    public Project(User user, Workspace workspace, String name, Set<String> tags) {
        this.id = "";
        this.userId = user.getId();
        this.workspace = workspace;
        this.workspaceId = workspace.getId();
        this.name = name;
        this.tags = tags;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @JsonIgnore
    public Workspace getWorkspace() {
        return this.workspace;
    }

    @JsonIgnore
    public String getBaseUrl() {
        return this.workspace.getBaseUrl() + "/project/" + this.id;
    }

    @JsonIgnore
    public String getUrl() {
        return this.getBaseUrl() + "/design";
    }
}

