/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.octoperf.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import us.abstracta.jmeter.javadsl.octoperf.api.Project;
import us.abstracta.jmeter.javadsl.octoperf.api.User;
import us.abstracta.jmeter.javadsl.octoperf.api.UserLoad;

public class Scenario {
    private final String id;
    private final String userId;
    private final String projectId;
    private final String name;
    private final String description = "";
    private final List<UserLoad> userLoads;
    private final String mode = "STANDARD";
    private final Instant created = Instant.now();
    private final Instant lastModified = Instant.now();
    private final Set<String> tags;
    private final BackendListenerSettings backendListeners = new BackendListenerSettings();
    private Project project;

    @JsonCreator
    public Scenario(@JsonProperty(value="id") String id, @JsonProperty(value="tags") Set<String> tags) {
        this.id = id;
        this.userId = null;
        this.projectId = null;
        this.name = null;
        this.userLoads = null;
        this.tags = tags;
    }

    public Scenario(User user, Project project, String name, List<UserLoad> userLoads, Set<String> tags) {
        this.id = "";
        this.userId = user.getId();
        this.project = project;
        this.projectId = project.getId();
        this.name = name;
        this.userLoads = userLoads;
        this.tags = tags;
    }

    public String getId() {
        return this.id;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    @JsonIgnore
    public Project getProject() {
        return this.project;
    }

    @JsonIgnore
    public String getUrl() {
        return this.project.getBaseUrl() + "/runtime/scenario/" + this.id;
    }

    public static class BackendListener {
    }

    public static class BackendListenerSettings {
        private final int queueSize = 5000;
        private final List<BackendListener> listeners = Collections.emptyList();
    }
}

