/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.parallel;

import com.blazemeter.jmeter.controller.ParallelControllerGui;
import com.blazemeter.jmeter.controller.ParallelSampler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.jmeter.testelement.TestElement;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCall;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCallContext;
import us.abstracta.jmeter.javadsl.codegeneration.MethodParam;
import us.abstracta.jmeter.javadsl.codegeneration.SingleTestElementCallBuilder;
import us.abstracta.jmeter.javadsl.codegeneration.TestElementParamBuilder;
import us.abstracta.jmeter.javadsl.codegeneration.params.ChildrenParam;
import us.abstracta.jmeter.javadsl.core.controllers.BaseController;
import us.abstracta.jmeter.javadsl.core.threadgroups.BaseThreadGroup;

public class ParallelController
extends BaseController<ParallelController> {
    public static final String DEFAULT_NAME = "bzm - Parallel Controller";
    protected boolean generateParent = false;
    protected Integer maxThreads;

    public ParallelController(String name, List<BaseThreadGroup.ThreadGroupChild> children) {
        super(name == null ? DEFAULT_NAME : name, ParallelControllerGui.class, children);
    }

    public static ParallelController parallelController(BaseThreadGroup.ThreadGroupChild ... children) {
        return new ParallelController(null, Arrays.asList(children));
    }

    public static ParallelController parallelController(String name, BaseThreadGroup.ThreadGroupChild ... children) {
        return new ParallelController(name, Arrays.asList(children));
    }

    public static ParallelController parallelController() {
        return ParallelController.parallelController((String)null);
    }

    public static ParallelController parallelController(String name) {
        return new ParallelController(name, Collections.emptyList());
    }

    public ParallelController generateParentSample() {
        return this.generateParentSample(true);
    }

    public ParallelController generateParentSample(boolean enable) {
        this.generateParent = enable;
        return this;
    }

    public ParallelController maxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        return this;
    }

    protected TestElement buildTestElement() {
        ParallelSampler ret = new ParallelSampler();
        ret.setGenerateParent(this.generateParent);
        if (this.maxThreads != null) {
            ret.setMaxThreadNumber(this.maxThreads.intValue());
            ret.setLimitMaxThreadNumber(true);
        }
        return ret;
    }

    public static class CodeBuilder
    extends SingleTestElementCallBuilder<ParallelSampler> {
        public CodeBuilder(List<Method> builderMethods) {
            super(ParallelSampler.class, builderMethods);
        }

        protected MethodCall buildMethodCall(ParallelSampler testElement, MethodCallContext context) {
            TestElementParamBuilder paramBuilder = new TestElementParamBuilder((TestElement)testElement);
            MethodCall ret = this.buildMethodCall(new MethodParam[]{paramBuilder.nameParam(ParallelController.DEFAULT_NAME), new ChildrenParam(BaseThreadGroup.ThreadGroupChild[].class)}).chain("generateParentSample", new MethodParam[]{paramBuilder.boolParam("PARENT_SAMPLE", false)});
            if (!paramBuilder.boolParam("LIMIT_MAX_THREAD_NUMBER", false).isDefault()) {
                ret.chain("maxThreads", new MethodParam[]{paramBuilder.intParam("MAX_THREAD_NUMBER")});
            }
            return ret;
        }
    }
}

