/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.wrapper.wrappers;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.DoubleProperty;
import org.apache.jmeter.testelement.property.FloatProperty;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.LongProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCall;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCallBuilder;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCallContext;
import us.abstracta.jmeter.javadsl.codegeneration.MethodParam;
import us.abstracta.jmeter.javadsl.codegeneration.SingleTestElementCallBuilder;
import us.abstracta.jmeter.javadsl.codegeneration.params.NameParam;
import us.abstracta.jmeter.javadsl.codegeneration.params.StringParam;
import us.abstracta.jmeter.javadsl.core.testelements.BaseTestElement;

public class TestElementWrapperCallBuilder<T extends TestElement>
extends SingleTestElementCallBuilder<T> {
    protected final Set<String> ignoredProperties = new HashSet<String>(Arrays.asList("TestElement.name", "TestElement.test_class", "TestElement.gui_class", "TestElement.enabled", "TestPlan.comments"));
    private final Class<? extends JMeterGUIComponent> guiClass;

    public TestElementWrapperCallBuilder(Class<T> testElementClass, Class<? extends JMeterGUIComponent> guiClass, List<Method> builderMethods) {
        super(testElementClass, builderMethods);
        this.guiClass = guiClass;
    }

    public boolean matches(MethodCallContext context) {
        return this.testElementClass.isInstance(context.getTestElement());
    }

    protected MethodCall buildMethodCall(T testElement, MethodCallContext context) {
        TestElement defaultInstance;
        ClassInstanceParam builderParam;
        try {
            if (testElement instanceof TestBean) {
                Class<?> constructorClass = testElement.getClass();
                builderParam = new ClassInstanceParam(this.testElementClass, constructorClass);
                defaultInstance = (TestElement)constructorClass.newInstance();
                BaseTestElement.loadBeanProperties((TestElement)defaultInstance);
            } else {
                String guiClassName = testElement.getPropertyAsString("TestElement.gui_class");
                Class<?> constructorClass = Class.forName(guiClassName);
                builderParam = new ClassInstanceParam(this.guiClass, constructorClass);
                JMeterGUIComponent guiComponent = (JMeterGUIComponent)constructorClass.newInstance();
                guiComponent.clearGui();
                defaultInstance = guiComponent.createTestElement();
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        MethodCall ret = this.buildMethodCall(new MethodParam[]{new NameParam(testElement.getName(), defaultInstance.getName()), builderParam});
        TestElementWrapperCallBuilder.propertyIterator2Stream((PropertyIterator)testElement.propertyIterator()).filter(p -> !this.isPropertyWithDefaultValue((JMeterProperty)p, (T)defaultInstance) && !this.ignoredProperties.contains(p.getName())).map(x$0 -> new PropertyParam((JMeterProperty)x$0)).filter(p -> !p.isDefault()).forEach(p -> ret.chain("prop", new MethodParam[]{new StringParam(((PropertyParam)p).getName()), p}));
        return ret;
    }

    private boolean isPropertyWithDefaultValue(JMeterProperty p, T defaultInstance) {
        return Objects.equals(p.getObjectValue(), defaultInstance.getProperty(p.getName()).getObjectValue());
    }

    private static class ClassInstanceParam
    extends MethodParam {
        private final Class<?> constructorType;

        private ClassInstanceParam(Class<?> paramType, Class<?> constructorType) {
            super(paramType, null);
            this.constructorType = constructorType;
        }

        public Set<String> getImports() {
            return Collections.singleton(this.constructorType.getName());
        }

        protected String buildCode(String indent) {
            return "new " + this.constructorType.getSimpleName() + "()";
        }
    }

    private static class PropertyParam
    extends MethodParam {
        private static final List<Class<? extends JMeterProperty>> LITERAL_PROPERTY_TYPES = Arrays.asList(NullProperty.class, BooleanProperty.class, IntegerProperty.class, LongProperty.class, FloatProperty.class, DoubleProperty.class);
        private final JMeterProperty prop;

        private PropertyParam(JMeterProperty prop) {
            super(Object.class, prop.getStringValue());
            this.prop = prop;
        }

        private String getName() {
            return this.prop.getName();
        }

        public boolean isDefault() {
            return super.isDefault() || this.prop instanceof CollectionProperty && ((CollectionProperty)this.prop).isEmpty();
        }

        public Set<String> getImports() {
            if (this.prop instanceof CollectionProperty) {
                return Collections.singleton((((CollectionProperty)this.prop).size() == 1 ? Collections.class : Arrays.class).getName());
            }
            return Collections.emptySet();
        }

        protected String buildCode(String indent) {
            if (LITERAL_PROPERTY_TYPES.stream().anyMatch(pt -> pt.isInstance(this.prop))) {
                return this.prop.getStringValue();
            }
            if (this.prop instanceof CollectionProperty) {
                return this.buildCollectionCode((CollectionProperty)this.prop, indent);
            }
            return PropertyParam.buildStringLiteral((String)this.prop.getStringValue(), (String)indent);
        }

        private String buildCollectionCode(CollectionProperty prop, String indent) {
            if (prop.size() == 1) {
                return "Collections.singletonList(" + new PropertyParam(prop.get(0)).buildCode(indent) + ")";
            }
            String childIndent = indent + "  ";
            return "Arrays.asList(\n" + MethodCallBuilder.propertyIterator2Stream((PropertyIterator)prop.iterator()).map(p -> childIndent + new PropertyParam((JMeterProperty)p).buildCode(childIndent)).collect(Collectors.joining(",\n")) + "\n" + indent + ")";
        }
    }
}

