/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.loader.counts;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import schemacrawler.loader.counts.TableRowCountsUtility;
import schemacrawler.schema.Table;
import schemacrawler.test.utility.crawl.LightTable;

public class TableRowCountsUtilityTest {
    @Test
    public void add() {
        LightTable table = new LightTable("table1");
        TableRowCountsUtility.addRowCountToTable(null, (long)0L);
        MatcherAssert.assertThat((Object)TableRowCountsUtility.hasRowCount(null), (Matcher)CoreMatchers.is((Object)false));
        TableRowCountsUtility.addRowCountToTable((Table)table, (long)1L);
        MatcherAssert.assertThat((Object)TableRowCountsUtility.hasRowCount((Table)table), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)TableRowCountsUtility.getRowCount((Table)table), (Matcher)CoreMatchers.is((Object)1L));
        TableRowCountsUtility.addRowCountToTable((Table)table, (long)0L);
        MatcherAssert.assertThat((Object)TableRowCountsUtility.hasRowCount((Table)table), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)TableRowCountsUtility.getRowCount((Table)table), (Matcher)CoreMatchers.is((Object)0L));
        TableRowCountsUtility.addRowCountToTable((Table)table, (long)-1L);
        MatcherAssert.assertThat((Object)TableRowCountsUtility.hasRowCount((Table)table), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)TableRowCountsUtility.getRowCount((Table)table), (Matcher)CoreMatchers.is((Object)-1L));
    }

    @Test
    public void message() {
        LightTable table = new LightTable("table1");
        NullPointerException nullPointerException = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> TableRowCountsUtility.getRowCountMessage((Number)null));
        MatcherAssert.assertThat((Object)nullPointerException.getMessage(), (Matcher)CoreMatchers.is((Object)"No number provided"));
        MatcherAssert.assertThat((Object)TableRowCountsUtility.getRowCountMessage((Number)-1), (Matcher)CoreMatchers.is((Object)"empty"));
        MatcherAssert.assertThat((Object)TableRowCountsUtility.getRowCountMessage((Number)0), (Matcher)CoreMatchers.is((Object)"empty"));
        MatcherAssert.assertThat((Object)TableRowCountsUtility.getRowCountMessage((Number)1), (Matcher)CoreMatchers.is((Object)"1 rows"));
        MatcherAssert.assertThat((Object)TableRowCountsUtility.getRowCountMessage((Table)null), (Matcher)CoreMatchers.is((Object)"empty"));
        MatcherAssert.assertThat((Object)TableRowCountsUtility.getRowCountMessage((Table)table), (Matcher)CoreMatchers.is((Object)"empty"));
        TableRowCountsUtility.addRowCountToTable((Table)table, (long)1L);
        MatcherAssert.assertThat((Object)TableRowCountsUtility.getRowCountMessage((Table)table), (Matcher)CoreMatchers.is((Object)"1 rows"));
    }
}

