/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.loader.weakassociations;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import schemacrawler.loader.weakassociations.ColumnMatchKeysMap;
import schemacrawler.schema.Column;
import schemacrawler.schema.NamedObject;
import schemacrawler.test.utility.crawl.LightColumn;
import schemacrawler.test.utility.crawl.LightTable;

public class ColumnMatchKeysMapTest {
    @Test
    public void columnMatchKeysMap_mixed_suffixes() {
        LightTable table1 = new LightTable("Table1");
        table1.addColumn("EntityId");
        LightTable table2 = new LightTable("Table2");
        table2.addColumn("Entity_Id");
        LightTable table3 = new LightTable("Table3");
        table3.addColumn("Entity_ID");
        LightTable table4 = new LightTable("Table4");
        table4.addColumn("EntityID");
        LightTable table5 = new LightTable("Table5");
        table5.addColumn("NonEntity");
        ColumnMatchKeysMap columnMatchKeysMap = new ColumnMatchKeysMap(Arrays.asList(table1, table2, table3, table4, table5));
        MatcherAssert.assertThat((Object)columnMatchKeysMap.toString(), (Matcher)CoreMatchers.is((Object)"{nonentity=[Table5.NonEntity], entity=[Table1.EntityId, Table2.Entity_Id, Table3.Entity_ID, Table4.EntityID]}"));
        MatcherAssert.assertThat((Object)columnMatchKeysMap.containsKey("entity"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(columnMatchKeysMap.get("entity").stream().map(NamedObject::getFullName).collect(Collectors.toSet()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Table1.EntityId", "Table2.Entity_Id", "Table3.Entity_ID", "Table4.EntityID"}));
        LightColumn column = new LightColumn(table4, "EntityID");
        MatcherAssert.assertThat((Object)columnMatchKeysMap.containsKey((Column)column), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(columnMatchKeysMap.get((Column)column).stream().collect(Collectors.toSet()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"entity"}));
    }

    @Test
    public void id() {
        LightTable table1 = new LightTable("Table1");
        table1.addColumn("id");
        LightTable table2 = new LightTable("Table2");
        table2.addColumn("_id");
        LightTable table3 = new LightTable("Table3");
        table3.addColumn("ID");
        LightTable table4 = new LightTable("Table4");
        table4.addColumn("_ID");
        ColumnMatchKeysMap columnMatchKeysMap = new ColumnMatchKeysMap(Arrays.asList(table1, table2, table3, table4));
        MatcherAssert.assertThat((Object)columnMatchKeysMap.toString(), (Matcher)CoreMatchers.is((Object)"{}"));
        MatcherAssert.assertThat((Object)columnMatchKeysMap.containsKey("entity"), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)columnMatchKeysMap.containsKey(""), (Matcher)CoreMatchers.is((Object)false));
        LightColumn column = new LightColumn(table4, "EntityID");
        MatcherAssert.assertThat((Object)columnMatchKeysMap.containsKey((Column)column), (Matcher)CoreMatchers.is((Object)false));
    }
}

