/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.loader.weakassociations;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import schemacrawler.loader.weakassociations.ProposedWeakAssociation;
import schemacrawler.schema.Column;
import schemacrawler.test.utility.crawl.LightColumn;
import schemacrawler.test.utility.crawl.LightTable;

public class ProposedWeakAssociationTest {
    @Test
    public void proposedWeakAssociation() {
        LightTable table1 = new LightTable("Table1");
        LightColumn col1 = table1.addColumn("Id");
        LightColumn col2 = table1.addColumn("ColA");
        Assertions.assertThrows(NullPointerException.class, () -> new ProposedWeakAssociation(null, col2));
        Assertions.assertThrows(NullPointerException.class, () -> new ProposedWeakAssociation(col1, null));
        Assertions.assertThrows(NullPointerException.class, () -> new ProposedWeakAssociation(null, null));
        ProposedWeakAssociation proposedWeakAssociation = new ProposedWeakAssociation((Column)col1, (Column)col2);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> proposedWeakAssociation.compareTo(null));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> proposedWeakAssociation.getKeySequence());
        MatcherAssert.assertThat((Object)proposedWeakAssociation.getPrimaryKeyColumn(), (Matcher)CoreMatchers.is((Object)col2));
        MatcherAssert.assertThat((Object)proposedWeakAssociation.getForeignKeyColumn(), (Matcher)CoreMatchers.is((Object)col1));
        MatcherAssert.assertThat((Object)proposedWeakAssociation.toString(), (Matcher)CoreMatchers.is((Object)"Table1.Id ~~> Table1.ColA"));
        MatcherAssert.assertThat((Object)proposedWeakAssociation.isValid(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)new ProposedWeakAssociation((Column)col1, (Column)col1).isValid(), (Matcher)CoreMatchers.is((Object)false));
    }
}

