/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.loader.weakassociations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import schemacrawler.loader.weakassociations.TableMatchKeys;
import schemacrawler.schema.Table;
import schemacrawler.test.utility.crawl.LightTable;

public class TableMatchKeysTest {
    @Test
    public void tableMatchKeys_boundaries() {
        Assertions.assertThrows(NullPointerException.class, () -> new TableMatchKeys(null));
        TableMatchKeys matchkeys = new TableMatchKeys(Collections.emptyList());
        MatcherAssert.assertThat((Object)matchkeys.toString(), (Matcher)CoreMatchers.is((Object)"{}"));
        List withoutPrefix = matchkeys.get((Table)new LightTable("table0"));
        MatcherAssert.assertThat((Object)withoutPrefix, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"table0"}));
        matchkeys = new TableMatchKeys(this.tables("table1"));
        MatcherAssert.assertThat((Object)matchkeys.toString(), (Matcher)CoreMatchers.is((Object)"{table1=[table1]}"));
        withoutPrefix = matchkeys.get((Table)new LightTable("table0"));
        MatcherAssert.assertThat((Object)withoutPrefix, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"table0"}));
        withoutPrefix = matchkeys.get((Table)new LightTable("table1"));
        MatcherAssert.assertThat((Object)withoutPrefix, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"table1"}));
        withoutPrefix = matchkeys.get(null);
        MatcherAssert.assertThat((Object)withoutPrefix, (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void tableMatchKeys_mixed_prefixes() {
        TableMatchKeys matchkeys = new TableMatchKeys(this.tables("vap_old_table1", "vap_old_table2", "vap_table3"));
        List withoutPrefix = matchkeys.get((Table)new LightTable("table0"));
        MatcherAssert.assertThat((Object)withoutPrefix, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"table0"}));
        withoutPrefix = matchkeys.get((Table)new LightTable("vap_old_table1"));
        MatcherAssert.assertThat((Object)withoutPrefix, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"table1", "old_table1", "vap_old_table1"}));
        withoutPrefix = matchkeys.get((Table)new LightTable("vap_old_table2"));
        MatcherAssert.assertThat((Object)withoutPrefix, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"table2", "old_table2", "vap_old_table2"}));
        withoutPrefix = matchkeys.get((Table)new LightTable("vap_table3"));
        MatcherAssert.assertThat((Object)withoutPrefix, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"table3", "vap_table3"}));
    }

    private List<Table> tables(String ... tableNames) {
        Objects.requireNonNull(tableNames);
        ArrayList<Table> tables = new ArrayList<Table>();
        for (String tableName : tableNames) {
            tables.add(new LightTable(tableName));
        }
        return tables;
    }
}

