/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.RegularExpressionExclusionRule;
import schemacrawler.loader.attributes.model.AlternateKeyAttributes;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.PrimaryKey;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableConstraintColumn;
import schemacrawler.schemacrawler.LimitOptionsBuilder;
import schemacrawler.schemacrawler.LoadOptionsBuilder;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.SchemaInfoLevelBuilder;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.test.utility.FileHasContent;
import schemacrawler.test.utility.ResolveTestContext;
import schemacrawler.test.utility.TestContext;
import schemacrawler.test.utility.TestOutputCapture;
import schemacrawler.test.utility.TestResource;
import schemacrawler.test.utility.TestUtility;
import schemacrawler.test.utility.TestWriter;
import schemacrawler.test.utility.WithTestDatabase;
import schemacrawler.tools.options.Config;
import schemacrawler.tools.utility.SchemaCrawlerUtility;
import us.fatehi.utility.datasource.DatabaseConnectionSource;

@WithTestDatabase
@ResolveTestContext
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class AlternateKeysAttributesTest {
    private Catalog catalog;

    @Test
    public void alternateKeyAttributesConstructor() {
        Exception exception = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> new AlternateKeyAttributes("schema", "catalog", "  ", "alternate_key", Arrays.asList("remarks", "other remarks"), Collections.emptyMap(), Arrays.asList("column1", "column2")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.is((Object)"No table name provided"));
        exception = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> new AlternateKeyAttributes("schema", "catalog", "table", "alternate_key", Arrays.asList("remarks", "other remarks"), Collections.emptyMap(), Collections.emptyList()));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.is((Object)"No columns provided"));
        exception = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> new AlternateKeyAttributes("schema", "catalog", "table", "alternate_key", Arrays.asList("remarks", "other remarks"), Collections.emptyMap(), null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.is((Object)"No columns provided"));
        AlternateKeyAttributes alternateKeyAttributes = new AlternateKeyAttributes("schema", "catalog", "table", "alternate_key", Arrays.asList("remarks", "other remarks"), Collections.emptyMap(), Arrays.asList("column1", "column2"));
        MatcherAssert.assertThat((Object)alternateKeyAttributes.toString(), (Matcher)CoreMatchers.is((Object)"Alternate key attributes <schema.catalog.table.alternate_key[[column1, column2]]>"));
    }

    @Test
    public void alternateKeys(TestContext testContext) throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            Schema[] schemas = this.catalog.getSchemas().toArray(new Schema[0]);
            MatcherAssert.assertThat((String)"Schema count does not match", (Object)schemas, (Matcher)Matchers.arrayWithSize((int)5));
            for (Schema schema : schemas) {
                Table[] tables;
                out.println("schema: " + schema.getFullName());
                for (Table table : tables = this.catalog.getTables(schema).toArray(new Table[0])) {
                    out.println("  table: " + table.getFullName());
                    Collection alternateKeys = table.getAlternateKeys();
                    this.printAlternateKeys(alternateKeys, out);
                }
            }
        }
        MatcherAssert.assertThat((Object)FileHasContent.outputOf((TestOutputCapture)testout), (Matcher)FileHasContent.hasSameContentAs((TestResource)FileHasContent.classpathResource((String)testContext.testMethodFullName())));
    }

    @BeforeAll
    public void loadCatalog(DatabaseConnectionSource dataSource) throws Exception {
        SchemaRetrievalOptions schemaRetrievalOptions = TestUtility.newSchemaRetrievalOptions();
        LimitOptionsBuilder limitOptionsBuilder = LimitOptionsBuilder.builder().includeSchemas((InclusionRule)new RegularExpressionExclusionRule(".*\\.FOR_LINT")).includeAllSynonyms().includeAllSequences().includeAllRoutines();
        LoadOptionsBuilder loadOptionsBuilder = LoadOptionsBuilder.builder().withSchemaInfoLevel(SchemaInfoLevelBuilder.standard());
        SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions().withLimitOptions(limitOptionsBuilder.toOptions()).withLoadOptions(loadOptionsBuilder.toOptions());
        Config additionalConfig = new Config();
        additionalConfig.put("attributes-file", (Object)"/attributes-alternate-keys.yaml");
        this.catalog = SchemaCrawlerUtility.getCatalog((DatabaseConnectionSource)dataSource, (SchemaRetrievalOptions)schemaRetrievalOptions, (SchemaCrawlerOptions)schemaCrawlerOptions, (Config)additionalConfig);
    }

    private void printAlternateKeys(Collection<? extends PrimaryKey> alternateKeys, TestWriter out) {
        for (PrimaryKey primaryKey : alternateKeys) {
            out.println("    alternate key: " + primaryKey.getName());
            List constrainedColumns = primaryKey.getConstrainedColumns();
            for (TableConstraintColumn column : constrainedColumns) {
                out.println("      column: " + column);
                out.println("        key sequence: " + column.getOrdinalPosition());
            }
            out.println("      remarks: " + primaryKey.getRemarks());
            out.println("      attributes: " + primaryKey.getAttributes());
        }
    }
}

