/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Column;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.test.utility.FileHasContent;
import schemacrawler.test.utility.ResolveTestContext;
import schemacrawler.test.utility.TestContext;
import schemacrawler.test.utility.TestOutputCapture;
import schemacrawler.test.utility.TestResource;
import schemacrawler.test.utility.TestUtility;
import schemacrawler.test.utility.TestWriter;
import schemacrawler.test.utility.WithTestDatabase;
import schemacrawler.tools.options.Config;
import schemacrawler.tools.utility.SchemaCrawlerUtility;
import us.fatehi.utility.datasource.DatabaseConnectionSource;

@WithTestDatabase
@ResolveTestContext
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class AttributesCatalogLoaderTest {
    @Test
    public void noRemarksForExternalColumn(TestContext testContext, DatabaseConnectionSource dataSource) throws Exception {
        String attributesFile = "/attributes-external-column.yaml";
        this.showRemarks(testContext, dataSource, "/attributes-external-column.yaml");
    }

    @Test
    public void noRemarksForExternalTable(TestContext testContext, DatabaseConnectionSource dataSource) throws Exception {
        String attributesFile = "/attributes-external-table.yaml";
        this.showRemarks(testContext, dataSource, "/attributes-external-table.yaml");
    }

    @Test
    public void showRemarks(TestContext testContext, DatabaseConnectionSource dataSource) throws Exception {
        String attributesFile = "/attributes.yaml";
        this.showRemarks(testContext, dataSource, "/attributes.yaml");
    }

    private void showRemarks(TestContext testContext, DatabaseConnectionSource dataSource, String attributesFile) throws IOException {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            SchemaRetrievalOptions schemaRetrievalOptions = TestUtility.newSchemaRetrievalOptions();
            SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
            Config additionalConfig = new Config();
            additionalConfig.put("attributes-file", (Object)attributesFile);
            Catalog catalog = SchemaCrawlerUtility.getCatalog((DatabaseConnectionSource)dataSource, (SchemaRetrievalOptions)schemaRetrievalOptions, (SchemaCrawlerOptions)schemaCrawlerOptions, (Config)additionalConfig);
            Schema[] schemas = catalog.getSchemas().toArray(new Schema[0]);
            MatcherAssert.assertThat((String)"Schema count does not match", (Object)schemas, (Matcher)Matchers.arrayWithSize((int)6));
            for (Schema schema : schemas) {
                for (Table table : catalog.getTables(schema)) {
                    out.println(String.format("- Table %s%n%s", table.getFullName(), table.getRemarks()));
                    for (Column column : table.getColumns()) {
                        out.println(String.format("-- Column %s%n%s", column.getFullName(), column.getRemarks()));
                    }
                    out.println();
                }
            }
        }
        MatcherAssert.assertThat((Object)FileHasContent.outputOf((TestOutputCapture)testout), (Matcher)FileHasContent.hasSameContentAs((TestResource)FileHasContent.classpathResource((String)testContext.testMethodFullName())));
    }
}

