/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.nio.file.Path;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import schemacrawler.loader.attributes.model.CatalogAttributes;
import schemacrawler.loader.attributes.model.CatalogAttributesUtility;
import schemacrawler.schemacrawler.exceptions.ConfigurationException;
import schemacrawler.test.utility.FileHasContent;
import schemacrawler.test.utility.TestResource;
import schemacrawler.test.utility.TestUtility;
import us.fatehi.utility.ioresource.InputResource;
import us.fatehi.utility.ioresource.InputResourceUtility;

public class AttributesModelTest {
    @Test
    @DisplayName(value="Invalid attributes file format")
    public void testParseBad2() {
        ConfigurationException exception = (ConfigurationException)Assertions.assertThrows(ConfigurationException.class, () -> {
            InputResource inputResource = (InputResource)InputResourceUtility.createInputResource((String)"/attributes-bad-2.yaml.bad").get();
            CatalogAttributesUtility.readCatalogAttributes((InputResource)inputResource);
        });
        MatcherAssert.assertThat((Object)exception.getCause().getMessage(), (Matcher)CoreMatchers.endsWith((String)"line: 1, column: 2]"));
    }

    @Test
    @DisplayName(value="Valid attributes file format, but incorrect data")
    public void testParseBad3() {
        ConfigurationException exception = (ConfigurationException)Assertions.assertThrows(ConfigurationException.class, () -> {
            InputResource inputResource = (InputResource)InputResourceUtility.createInputResource((String)"/attributes-bad-3.yaml").get();
            CatalogAttributesUtility.readCatalogAttributes((InputResource)inputResource);
        });
        MatcherAssert.assertThat((Object)exception.getCause().getMessage(), (Matcher)CoreMatchers.endsWith((String)"line: 1, column: 1]"));
    }

    @Test
    @DisplayName(value="\u263a Valid attributes file")
    public void testParseGood() throws Exception {
        InputResource inputResource = (InputResource)InputResourceUtility.createInputResource((String)"/attributes.yaml").get();
        CatalogAttributes catalogAttributes = CatalogAttributesUtility.readCatalogAttributes((InputResource)inputResource);
        MatcherAssert.assertThat((Object)FileHasContent.outputOf((Path)this.serialized(catalogAttributes)), (Matcher)FileHasContent.hasSameContentAs((TestResource)FileHasContent.classpathResource((String)"attributes.json")));
    }

    private Path serialized(CatalogAttributes catalogAttributes) throws Exception {
        JsonMapper jsonMapper = new JsonMapper();
        jsonMapper.enable(SerializationFeature.INDENT_OUTPUT);
        @JsonPropertyOrder(value={"catalogName", "schemaName", "name", "remarks", "attributes"}, alphabetic=true)
        class JacksonMixin {
            JacksonMixin() {
            }
        }
        jsonMapper.addMixIn(Object.class, JacksonMixin.class);
        jsonMapper.setVisibility(jsonMapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        return TestUtility.writeStringToTempFile((String)jsonMapper.writeValueAsString((Object)catalogAttributes));
    }
}

