/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.RegularExpressionExclusionRule;
import schemacrawler.loader.weakassociations.ProposedWeakAssociation;
import schemacrawler.loader.weakassociations.WeakAssociationsAnalyzer;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.LimitOptionsBuilder;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.SchemaReference;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.test.utility.DatabaseTestUtility;
import schemacrawler.test.utility.FileHasContent;
import schemacrawler.test.utility.ResolveTestContext;
import schemacrawler.test.utility.TestContext;
import schemacrawler.test.utility.TestOutputCapture;
import schemacrawler.test.utility.TestResource;
import schemacrawler.test.utility.TestUtility;
import schemacrawler.test.utility.TestWriter;
import schemacrawler.test.utility.WithTestDatabase;

@WithTestDatabase
@ResolveTestContext
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class WeakAssociationsAnalyzerTest {
    private Catalog catalog;

    @BeforeAll
    public void loadCatalog(Connection connection) throws Exception {
        SchemaRetrievalOptions schemaRetrievalOptions = TestUtility.newSchemaRetrievalOptions();
        LimitOptionsBuilder limitOptionsBuilder = LimitOptionsBuilder.builder().includeSchemas((InclusionRule)new RegularExpressionExclusionRule(".*\\.FOR_LINT"));
        SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions().withLimitOptions(limitOptionsBuilder.toOptions());
        this.catalog = DatabaseTestUtility.getCatalog((Connection)connection, (SchemaRetrievalOptions)schemaRetrievalOptions, (SchemaCrawlerOptions)schemaCrawlerOptions);
    }

    @Test
    public void weakAssociations(TestContext testContext, Connection connection) throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            WeakAssociationsAnalyzer weakAssociationsAnalyzer = new WeakAssociationsAnalyzer(this.catalog.getTables(), w -> true);
            Collection proposedWeakAssociations = weakAssociationsAnalyzer.analyzeTables();
            MatcherAssert.assertThat((String)"Proposed weak association count does not match", (Object)proposedWeakAssociations, (Matcher)Matchers.hasSize((int)6));
            for (ProposedWeakAssociation proposedWeakAssociation : proposedWeakAssociations) {
                out.println(String.format("weak association: %s", proposedWeakAssociation));
                MatcherAssert.assertThat((Object)((Table)proposedWeakAssociation.getPrimaryKeyColumn().getParent()).getWeakAssociations(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
                MatcherAssert.assertThat((Object)((Table)proposedWeakAssociation.getForeignKeyColumn().getParent()).getWeakAssociations(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
            }
        }
        MatcherAssert.assertThat((Object)FileHasContent.outputOf((TestOutputCapture)testout), (Matcher)FileHasContent.hasSameContentAs((TestResource)FileHasContent.classpathResource((String)testContext.testMethodFullName())));
    }

    @Test
    public void weakAssociationsFewTables() throws Exception {
        MatcherAssert.assertThat((Object)new WeakAssociationsAnalyzer(new ArrayList(), w -> true).analyzeTables(), (Matcher)Matchers.hasSize((int)0));
        Table booksTable = (Table)this.catalog.lookupTable((Schema)new SchemaReference("PUBLIC", "BOOKS"), "BOOKS").get();
        Table bookAuthorsTable = (Table)this.catalog.lookupTable((Schema)new SchemaReference("PUBLIC", "BOOKS"), "BOOKAUTHORS").get();
        MatcherAssert.assertThat((Object)new WeakAssociationsAnalyzer(Arrays.asList(booksTable), w -> true).analyzeTables(), (Matcher)Matchers.hasSize((int)0));
        MatcherAssert.assertThat((Object)new WeakAssociationsAnalyzer(Arrays.asList(booksTable, bookAuthorsTable), w -> true).analyzeTables(), (Matcher)Matchers.hasSize((int)1));
    }
}

