/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.RegularExpressionExclusionRule;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableReference;
import schemacrawler.schemacrawler.LimitOptionsBuilder;
import schemacrawler.schemacrawler.LoadOptionsBuilder;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.SchemaInfoLevelBuilder;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.test.utility.FileHasContent;
import schemacrawler.test.utility.ResolveTestContext;
import schemacrawler.test.utility.TestContext;
import schemacrawler.test.utility.TestOutputCapture;
import schemacrawler.test.utility.TestResource;
import schemacrawler.test.utility.TestUtility;
import schemacrawler.test.utility.TestWriter;
import schemacrawler.test.utility.WithTestDatabase;
import schemacrawler.tools.options.Config;
import schemacrawler.tools.utility.SchemaCrawlerUtility;
import us.fatehi.utility.Utility;
import us.fatehi.utility.datasource.DatabaseConnectionSource;

@WithTestDatabase
@ResolveTestContext
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class WeakAssociationsAttributesTest {
    private Catalog catalog;

    @BeforeAll
    public void loadCatalog(TestContext testContext, DatabaseConnectionSource dataSource) throws Exception {
        SchemaRetrievalOptions schemaRetrievalOptions = TestUtility.newSchemaRetrievalOptions();
        LimitOptionsBuilder limitOptionsBuilder = LimitOptionsBuilder.builder().includeSchemas((InclusionRule)new RegularExpressionExclusionRule(".*\\.FOR_LINT"));
        LoadOptionsBuilder loadOptionsBuilder = LoadOptionsBuilder.builder().withSchemaInfoLevel(SchemaInfoLevelBuilder.standard());
        SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions().withLimitOptions(limitOptionsBuilder.toOptions()).withLoadOptions(loadOptionsBuilder.toOptions());
        Config additionalConfig = new Config();
        additionalConfig.put("weak-associations", (Object)Boolean.TRUE);
        additionalConfig.put("attributes-file", (Object)"/attributes-weakassociations.yaml");
        this.catalog = SchemaCrawlerUtility.getCatalog((DatabaseConnectionSource)dataSource, (SchemaRetrievalOptions)schemaRetrievalOptions, (SchemaCrawlerOptions)schemaCrawlerOptions, (Config)additionalConfig);
    }

    @Test
    public void weakAssociations(TestContext testContext) throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            Schema[] schemas = this.catalog.getSchemas().toArray(new Schema[0]);
            MatcherAssert.assertThat((String)"Schema count does not match", (Object)schemas, (Matcher)Matchers.arrayWithSize((int)5));
            for (Schema schema : schemas) {
                Table[] tables;
                out.println("schema: " + schema.getFullName());
                for (Table table : tables = this.catalog.getTables(schema).toArray(new Table[0])) {
                    out.println("  table: " + table.getFullName());
                    Collection foreignKeys = table.getForeignKeys();
                    this.printTableReferences("foreign-key", foreignKeys, out);
                    Collection weakAssociations = table.getWeakAssociations();
                    this.printTableReferences("weak-association", weakAssociations, out);
                }
            }
        }
        MatcherAssert.assertThat((Object)FileHasContent.outputOf((TestOutputCapture)testout), (Matcher)FileHasContent.hasSameContentAs((TestResource)FileHasContent.classpathResource((String)testContext.testMethodFullName())));
    }

    private void printTableReferences(String tableReferenceType, Collection<? extends TableReference> tableReferences, TestWriter out) {
        for (TableReference tableReference : tableReferences) {
            Map attributes;
            out.println("    " + tableReferenceType + ": " + tableReference.getName());
            out.println("      column references: ");
            List columnReferences = tableReference.getColumnReferences();
            for (int i = 0; i < columnReferences.size(); ++i) {
                ColumnReference columnReference = (ColumnReference)columnReferences.get(i);
                out.println("        key sequence: " + (i + 1));
                out.println("          " + columnReference);
            }
            String remarks = tableReference.getRemarks();
            if (!Utility.isBlank((CharSequence)remarks)) {
                out.println("      remarks: " + remarks);
            }
            if ((attributes = tableReference.getAttributes()).isEmpty()) continue;
            out.println("      attributes: ");
            Set entrySet = attributes.entrySet();
            for (Map.Entry entry : entrySet) {
                out.println(String.format("        %s: %s", entry.getKey(), entry.getValue()));
            }
        }
    }
}

