/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test.utility;

import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableReference;
import schemacrawler.schema.WeakAssociation;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaReference;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptionsBuilder;
import schemacrawler.test.utility.DatabaseTestUtility;
import schemacrawler.test.utility.FileHasContent;
import schemacrawler.test.utility.TestContext;
import schemacrawler.test.utility.TestOutputCapture;
import schemacrawler.test.utility.TestResource;
import schemacrawler.test.utility.TestWriter;
import schemacrawler.tools.options.Config;
import schemacrawler.tools.utility.SchemaCrawlerUtility;
import schemacrawler.utility.MetaDataUtility;
import schemacrawler.utility.NamedObjectSort;
import us.fatehi.utility.datasource.DatabaseConnectionSource;

public class ProposedWeakAssociationsTestUtility {
    public static void weakAssociations(TestContext testContext, DatabaseConnectionSource dataSource, boolean inferExtensionTables) throws Exception {
        TestWriter testout;
        String currentMethodFullName = inferExtensionTables ? testContext.testMethodFullName() + ".infer-extension-tables" : testContext.testMethodFullName();
        try (TestWriter out = testout = new TestWriter();){
            SchemaCrawlerOptions schemaCrawlerOptions = DatabaseTestUtility.schemaCrawlerOptionsWithMaximumSchemaInfoLevel;
            SchemaRetrievalOptions schemaRetrievalOptions = SchemaRetrievalOptionsBuilder.newSchemaRetrievalOptions();
            Config config = new Config();
            config.put("weak-associations", (Object)Boolean.TRUE);
            config.put("infer-extension-tables", (Object)inferExtensionTables);
            Catalog catalog = SchemaCrawlerUtility.getCatalog((DatabaseConnectionSource)dataSource, (SchemaRetrievalOptions)schemaRetrievalOptions, (SchemaCrawlerOptions)schemaCrawlerOptions, (Config)config);
            SchemaReference schema = new SchemaReference("PUBLIC", "PUBLIC");
            Table[] tables = catalog.getTables((Schema)schema).toArray(new Table[0]);
            Arrays.sort(tables, NamedObjectSort.alphabetical);
            for (Table table : tables) {
                out.println("table: " + table.getFullName());
                Collection weakAssociations = table.getWeakAssociations();
                for (WeakAssociation weakFk : weakAssociations) {
                    out.println(String.format("  weak association (1 to %s):", MetaDataUtility.findForeignKeyCardinality((TableReference)weakFk)));
                    for (ColumnReference weakAssociationColumnReference : weakFk) {
                        out.println(String.format("    column reference: %s", weakAssociationColumnReference));
                    }
                }
            }
        }
        MatcherAssert.assertThat((Object)FileHasContent.outputOf((TestOutputCapture)testout), (Matcher)FileHasContent.hasSameContentAs((TestResource)FileHasContent.classpathResource((String)currentMethodFullName)));
    }

    private ProposedWeakAssociationsTestUtility() {
    }
}

